// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * FunctionEnvelope resource specific properties.
 */
@Fluent
public final class FunctionEnvelopeProperties implements JsonSerializable<FunctionEnvelopeProperties> {
    /*
     * Function App ID.
     */
    private String functionAppId;

    /*
     * Script root path URI.
     */
    private String scriptRootPathHref;

    /*
     * Script URI.
     */
    private String scriptHref;

    /*
     * Config URI.
     */
    private String configHref;

    /*
     * Test data URI.
     */
    private String testDataHref;

    /*
     * Secrets file URI.
     */
    private String secretsFileHref;

    /*
     * Function URI.
     */
    private String href;

    /*
     * Config information.
     */
    private Object config;

    /*
     * File list.
     */
    private Map<String, String> files;

    /*
     * Test data used when testing via the Azure Portal.
     */
    private String testData;

    /*
     * The invocation URL
     */
    private String invokeUrlTemplate;

    /*
     * The function language
     */
    private String language;

    /*
     * Gets or sets a value indicating whether the function is disabled
     */
    private Boolean isDisabled;

    /**
     * Creates an instance of FunctionEnvelopeProperties class.
     */
    public FunctionEnvelopeProperties() {
    }

    /**
     * Get the functionAppId property: Function App ID.
     * 
     * @return the functionAppId value.
     */
    public String functionAppId() {
        return this.functionAppId;
    }

    /**
     * Set the functionAppId property: Function App ID.
     * 
     * @param functionAppId the functionAppId value to set.
     * @return the FunctionEnvelopeProperties object itself.
     */
    public FunctionEnvelopeProperties withFunctionAppId(String functionAppId) {
        this.functionAppId = functionAppId;
        return this;
    }

    /**
     * Get the scriptRootPathHref property: Script root path URI.
     * 
     * @return the scriptRootPathHref value.
     */
    public String scriptRootPathHref() {
        return this.scriptRootPathHref;
    }

    /**
     * Set the scriptRootPathHref property: Script root path URI.
     * 
     * @param scriptRootPathHref the scriptRootPathHref value to set.
     * @return the FunctionEnvelopeProperties object itself.
     */
    public FunctionEnvelopeProperties withScriptRootPathHref(String scriptRootPathHref) {
        this.scriptRootPathHref = scriptRootPathHref;
        return this;
    }

    /**
     * Get the scriptHref property: Script URI.
     * 
     * @return the scriptHref value.
     */
    public String scriptHref() {
        return this.scriptHref;
    }

    /**
     * Set the scriptHref property: Script URI.
     * 
     * @param scriptHref the scriptHref value to set.
     * @return the FunctionEnvelopeProperties object itself.
     */
    public FunctionEnvelopeProperties withScriptHref(String scriptHref) {
        this.scriptHref = scriptHref;
        return this;
    }

    /**
     * Get the configHref property: Config URI.
     * 
     * @return the configHref value.
     */
    public String configHref() {
        return this.configHref;
    }

    /**
     * Set the configHref property: Config URI.
     * 
     * @param configHref the configHref value to set.
     * @return the FunctionEnvelopeProperties object itself.
     */
    public FunctionEnvelopeProperties withConfigHref(String configHref) {
        this.configHref = configHref;
        return this;
    }

    /**
     * Get the testDataHref property: Test data URI.
     * 
     * @return the testDataHref value.
     */
    public String testDataHref() {
        return this.testDataHref;
    }

    /**
     * Set the testDataHref property: Test data URI.
     * 
     * @param testDataHref the testDataHref value to set.
     * @return the FunctionEnvelopeProperties object itself.
     */
    public FunctionEnvelopeProperties withTestDataHref(String testDataHref) {
        this.testDataHref = testDataHref;
        return this;
    }

    /**
     * Get the secretsFileHref property: Secrets file URI.
     * 
     * @return the secretsFileHref value.
     */
    public String secretsFileHref() {
        return this.secretsFileHref;
    }

    /**
     * Set the secretsFileHref property: Secrets file URI.
     * 
     * @param secretsFileHref the secretsFileHref value to set.
     * @return the FunctionEnvelopeProperties object itself.
     */
    public FunctionEnvelopeProperties withSecretsFileHref(String secretsFileHref) {
        this.secretsFileHref = secretsFileHref;
        return this;
    }

    /**
     * Get the href property: Function URI.
     * 
     * @return the href value.
     */
    public String href() {
        return this.href;
    }

    /**
     * Set the href property: Function URI.
     * 
     * @param href the href value to set.
     * @return the FunctionEnvelopeProperties object itself.
     */
    public FunctionEnvelopeProperties withHref(String href) {
        this.href = href;
        return this;
    }

    /**
     * Get the config property: Config information.
     * 
     * @return the config value.
     */
    public Object config() {
        return this.config;
    }

    /**
     * Set the config property: Config information.
     * 
     * @param config the config value to set.
     * @return the FunctionEnvelopeProperties object itself.
     */
    public FunctionEnvelopeProperties withConfig(Object config) {
        this.config = config;
        return this;
    }

    /**
     * Get the files property: File list.
     * 
     * @return the files value.
     */
    public Map<String, String> files() {
        return this.files;
    }

    /**
     * Set the files property: File list.
     * 
     * @param files the files value to set.
     * @return the FunctionEnvelopeProperties object itself.
     */
    public FunctionEnvelopeProperties withFiles(Map<String, String> files) {
        this.files = files;
        return this;
    }

    /**
     * Get the testData property: Test data used when testing via the Azure Portal.
     * 
     * @return the testData value.
     */
    public String testData() {
        return this.testData;
    }

    /**
     * Set the testData property: Test data used when testing via the Azure Portal.
     * 
     * @param testData the testData value to set.
     * @return the FunctionEnvelopeProperties object itself.
     */
    public FunctionEnvelopeProperties withTestData(String testData) {
        this.testData = testData;
        return this;
    }

    /**
     * Get the invokeUrlTemplate property: The invocation URL.
     * 
     * @return the invokeUrlTemplate value.
     */
    public String invokeUrlTemplate() {
        return this.invokeUrlTemplate;
    }

    /**
     * Set the invokeUrlTemplate property: The invocation URL.
     * 
     * @param invokeUrlTemplate the invokeUrlTemplate value to set.
     * @return the FunctionEnvelopeProperties object itself.
     */
    public FunctionEnvelopeProperties withInvokeUrlTemplate(String invokeUrlTemplate) {
        this.invokeUrlTemplate = invokeUrlTemplate;
        return this;
    }

    /**
     * Get the language property: The function language.
     * 
     * @return the language value.
     */
    public String language() {
        return this.language;
    }

    /**
     * Set the language property: The function language.
     * 
     * @param language the language value to set.
     * @return the FunctionEnvelopeProperties object itself.
     */
    public FunctionEnvelopeProperties withLanguage(String language) {
        this.language = language;
        return this;
    }

    /**
     * Get the isDisabled property: Gets or sets a value indicating whether the function is disabled.
     * 
     * @return the isDisabled value.
     */
    public Boolean isDisabled() {
        return this.isDisabled;
    }

    /**
     * Set the isDisabled property: Gets or sets a value indicating whether the function is disabled.
     * 
     * @param isDisabled the isDisabled value to set.
     * @return the FunctionEnvelopeProperties object itself.
     */
    public FunctionEnvelopeProperties withIsDisabled(Boolean isDisabled) {
        this.isDisabled = isDisabled;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("function_app_id", this.functionAppId);
        jsonWriter.writeStringField("script_root_path_href", this.scriptRootPathHref);
        jsonWriter.writeStringField("script_href", this.scriptHref);
        jsonWriter.writeStringField("config_href", this.configHref);
        jsonWriter.writeStringField("test_data_href", this.testDataHref);
        jsonWriter.writeStringField("secrets_file_href", this.secretsFileHref);
        jsonWriter.writeStringField("href", this.href);
        if (this.config != null) {
            jsonWriter.writeUntypedField("config", this.config);
        }
        jsonWriter.writeMapField("files", this.files, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("test_data", this.testData);
        jsonWriter.writeStringField("invoke_url_template", this.invokeUrlTemplate);
        jsonWriter.writeStringField("language", this.language);
        jsonWriter.writeBooleanField("isDisabled", this.isDisabled);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FunctionEnvelopeProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FunctionEnvelopeProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the FunctionEnvelopeProperties.
     */
    public static FunctionEnvelopeProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FunctionEnvelopeProperties deserializedFunctionEnvelopeProperties = new FunctionEnvelopeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("function_app_id".equals(fieldName)) {
                    deserializedFunctionEnvelopeProperties.functionAppId = reader.getString();
                } else if ("script_root_path_href".equals(fieldName)) {
                    deserializedFunctionEnvelopeProperties.scriptRootPathHref = reader.getString();
                } else if ("script_href".equals(fieldName)) {
                    deserializedFunctionEnvelopeProperties.scriptHref = reader.getString();
                } else if ("config_href".equals(fieldName)) {
                    deserializedFunctionEnvelopeProperties.configHref = reader.getString();
                } else if ("test_data_href".equals(fieldName)) {
                    deserializedFunctionEnvelopeProperties.testDataHref = reader.getString();
                } else if ("secrets_file_href".equals(fieldName)) {
                    deserializedFunctionEnvelopeProperties.secretsFileHref = reader.getString();
                } else if ("href".equals(fieldName)) {
                    deserializedFunctionEnvelopeProperties.href = reader.getString();
                } else if ("config".equals(fieldName)) {
                    deserializedFunctionEnvelopeProperties.config = reader.readUntyped();
                } else if ("files".equals(fieldName)) {
                    Map<String, String> files = reader.readMap(reader1 -> reader1.getString());
                    deserializedFunctionEnvelopeProperties.files = files;
                } else if ("test_data".equals(fieldName)) {
                    deserializedFunctionEnvelopeProperties.testData = reader.getString();
                } else if ("invoke_url_template".equals(fieldName)) {
                    deserializedFunctionEnvelopeProperties.invokeUrlTemplate = reader.getString();
                } else if ("language".equals(fieldName)) {
                    deserializedFunctionEnvelopeProperties.language = reader.getString();
                } else if ("isDisabled".equals(fieldName)) {
                    deserializedFunctionEnvelopeProperties.isDisabled = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFunctionEnvelopeProperties;
        });
    }
}
