// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Single sign-on request information for domain management.
 */
@Immutable
public final class DomainControlCenterSsoRequestInner implements JsonSerializable<DomainControlCenterSsoRequestInner> {
    /*
     * URL where the single sign-on request is to be made.
     */
    private String url;

    /*
     * Post parameter key.
     */
    private String postParameterKey;

    /*
     * Post parameter value. Client should use 'application/x-www-form-urlencoded' encoding for this value.
     */
    private String postParameterValue;

    /**
     * Creates an instance of DomainControlCenterSsoRequestInner class.
     */
    public DomainControlCenterSsoRequestInner() {
    }

    /**
     * Get the url property: URL where the single sign-on request is to be made.
     * 
     * @return the url value.
     */
    public String url() {
        return this.url;
    }

    /**
     * Get the postParameterKey property: Post parameter key.
     * 
     * @return the postParameterKey value.
     */
    public String postParameterKey() {
        return this.postParameterKey;
    }

    /**
     * Get the postParameterValue property: Post parameter value. Client should use 'application/x-www-form-urlencoded'
     * encoding for this value.
     * 
     * @return the postParameterValue value.
     */
    public String postParameterValue() {
        return this.postParameterValue;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DomainControlCenterSsoRequestInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DomainControlCenterSsoRequestInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DomainControlCenterSsoRequestInner.
     */
    public static DomainControlCenterSsoRequestInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DomainControlCenterSsoRequestInner deserializedDomainControlCenterSsoRequestInner
                = new DomainControlCenterSsoRequestInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("url".equals(fieldName)) {
                    deserializedDomainControlCenterSsoRequestInner.url = reader.getString();
                } else if ("postParameterKey".equals(fieldName)) {
                    deserializedDomainControlCenterSsoRequestInner.postParameterKey = reader.getString();
                } else if ("postParameterValue".equals(fieldName)) {
                    deserializedDomainControlCenterSsoRequestInner.postParameterValue = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDomainControlCenterSsoRequestInner;
        });
    }
}
