// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.CertificateDetails;
import com.azure.resourcemanager.appservice.models.CertificateOrderContact;
import com.azure.resourcemanager.appservice.models.CertificateOrderStatus;
import com.azure.resourcemanager.appservice.models.CertificateProductType;
import com.azure.resourcemanager.appservice.models.ProvisioningState;
import com.azure.resourcemanager.appservice.models.ResourceNotRenewableReason;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

/**
 * AppServiceCertificateOrderPatchResource resource specific properties.
 */
@Fluent
public final class AppServiceCertificateOrderPatchResourceProperties
    implements JsonSerializable<AppServiceCertificateOrderPatchResourceProperties> {
    /*
     * State of the Key Vault secret.
     */
    private Map<String, AppServiceCertificateInner> certificates;

    /*
     * Certificate distinguished name.
     */
    private String distinguishedName;

    /*
     * Domain verification token.
     */
    private String domainVerificationToken;

    /*
     * Duration in years (must be 1).
     */
    private Integer validityInYears;

    /*
     * Certificate key size.
     */
    private Integer keySize;

    /*
     * Certificate product type.
     */
    private CertificateProductType productType;

    /*
     * <code>true</code> if the certificate should be automatically renewed when it expires; otherwise,
     * <code>false</code>.
     */
    private Boolean autoRenew;

    /*
     * Status of certificate order.
     */
    private ProvisioningState provisioningState;

    /*
     * Current order status.
     */
    private CertificateOrderStatus status;

    /*
     * Signed certificate.
     */
    private CertificateDetails signedCertificate;

    /*
     * Last CSR that was created for this order.
     */
    private String csr;

    /*
     * Intermediate certificate.
     */
    private CertificateDetails intermediate;

    /*
     * Root certificate.
     */
    private CertificateDetails root;

    /*
     * Current serial number of the certificate.
     */
    private String serialNumber;

    /*
     * Certificate last issuance time.
     */
    private OffsetDateTime lastCertificateIssuanceTime;

    /*
     * Certificate expiration time.
     */
    private OffsetDateTime expirationTime;

    /*
     * <code>true</code> if private key is external; otherwise, <code>false</code>.
     */
    private Boolean isPrivateKeyExternal;

    /*
     * Reasons why App Service Certificate is not renewable at the current moment.
     */
    private List<ResourceNotRenewableReason> appServiceCertificateNotRenewableReasons;

    /*
     * Time stamp when the certificate would be auto renewed next
     */
    private OffsetDateTime nextAutoRenewalTimestamp;

    /*
     * Contact info
     */
    private CertificateOrderContact contact;

    /**
     * Creates an instance of AppServiceCertificateOrderPatchResourceProperties class.
     */
    public AppServiceCertificateOrderPatchResourceProperties() {
    }

    /**
     * Get the certificates property: State of the Key Vault secret.
     * 
     * @return the certificates value.
     */
    public Map<String, AppServiceCertificateInner> certificates() {
        return this.certificates;
    }

    /**
     * Set the certificates property: State of the Key Vault secret.
     * 
     * @param certificates the certificates value to set.
     * @return the AppServiceCertificateOrderPatchResourceProperties object itself.
     */
    public AppServiceCertificateOrderPatchResourceProperties
        withCertificates(Map<String, AppServiceCertificateInner> certificates) {
        this.certificates = certificates;
        return this;
    }

    /**
     * Get the distinguishedName property: Certificate distinguished name.
     * 
     * @return the distinguishedName value.
     */
    public String distinguishedName() {
        return this.distinguishedName;
    }

    /**
     * Set the distinguishedName property: Certificate distinguished name.
     * 
     * @param distinguishedName the distinguishedName value to set.
     * @return the AppServiceCertificateOrderPatchResourceProperties object itself.
     */
    public AppServiceCertificateOrderPatchResourceProperties withDistinguishedName(String distinguishedName) {
        this.distinguishedName = distinguishedName;
        return this;
    }

    /**
     * Get the domainVerificationToken property: Domain verification token.
     * 
     * @return the domainVerificationToken value.
     */
    public String domainVerificationToken() {
        return this.domainVerificationToken;
    }

    /**
     * Get the validityInYears property: Duration in years (must be 1).
     * 
     * @return the validityInYears value.
     */
    public Integer validityInYears() {
        return this.validityInYears;
    }

    /**
     * Set the validityInYears property: Duration in years (must be 1).
     * 
     * @param validityInYears the validityInYears value to set.
     * @return the AppServiceCertificateOrderPatchResourceProperties object itself.
     */
    public AppServiceCertificateOrderPatchResourceProperties withValidityInYears(Integer validityInYears) {
        this.validityInYears = validityInYears;
        return this;
    }

    /**
     * Get the keySize property: Certificate key size.
     * 
     * @return the keySize value.
     */
    public Integer keySize() {
        return this.keySize;
    }

    /**
     * Set the keySize property: Certificate key size.
     * 
     * @param keySize the keySize value to set.
     * @return the AppServiceCertificateOrderPatchResourceProperties object itself.
     */
    public AppServiceCertificateOrderPatchResourceProperties withKeySize(Integer keySize) {
        this.keySize = keySize;
        return this;
    }

    /**
     * Get the productType property: Certificate product type.
     * 
     * @return the productType value.
     */
    public CertificateProductType productType() {
        return this.productType;
    }

    /**
     * Set the productType property: Certificate product type.
     * 
     * @param productType the productType value to set.
     * @return the AppServiceCertificateOrderPatchResourceProperties object itself.
     */
    public AppServiceCertificateOrderPatchResourceProperties withProductType(CertificateProductType productType) {
        this.productType = productType;
        return this;
    }

    /**
     * Get the autoRenew property: &lt;code&gt;true&lt;/code&gt; if the certificate should be automatically renewed when
     * it expires; otherwise, &lt;code&gt;false&lt;/code&gt;.
     * 
     * @return the autoRenew value.
     */
    public Boolean autoRenew() {
        return this.autoRenew;
    }

    /**
     * Set the autoRenew property: &lt;code&gt;true&lt;/code&gt; if the certificate should be automatically renewed when
     * it expires; otherwise, &lt;code&gt;false&lt;/code&gt;.
     * 
     * @param autoRenew the autoRenew value to set.
     * @return the AppServiceCertificateOrderPatchResourceProperties object itself.
     */
    public AppServiceCertificateOrderPatchResourceProperties withAutoRenew(Boolean autoRenew) {
        this.autoRenew = autoRenew;
        return this;
    }

    /**
     * Get the provisioningState property: Status of certificate order.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the status property: Current order status.
     * 
     * @return the status value.
     */
    public CertificateOrderStatus status() {
        return this.status;
    }

    /**
     * Get the signedCertificate property: Signed certificate.
     * 
     * @return the signedCertificate value.
     */
    public CertificateDetails signedCertificate() {
        return this.signedCertificate;
    }

    /**
     * Get the csr property: Last CSR that was created for this order.
     * 
     * @return the csr value.
     */
    public String csr() {
        return this.csr;
    }

    /**
     * Set the csr property: Last CSR that was created for this order.
     * 
     * @param csr the csr value to set.
     * @return the AppServiceCertificateOrderPatchResourceProperties object itself.
     */
    public AppServiceCertificateOrderPatchResourceProperties withCsr(String csr) {
        this.csr = csr;
        return this;
    }

    /**
     * Get the intermediate property: Intermediate certificate.
     * 
     * @return the intermediate value.
     */
    public CertificateDetails intermediate() {
        return this.intermediate;
    }

    /**
     * Get the root property: Root certificate.
     * 
     * @return the root value.
     */
    public CertificateDetails root() {
        return this.root;
    }

    /**
     * Get the serialNumber property: Current serial number of the certificate.
     * 
     * @return the serialNumber value.
     */
    public String serialNumber() {
        return this.serialNumber;
    }

    /**
     * Get the lastCertificateIssuanceTime property: Certificate last issuance time.
     * 
     * @return the lastCertificateIssuanceTime value.
     */
    public OffsetDateTime lastCertificateIssuanceTime() {
        return this.lastCertificateIssuanceTime;
    }

    /**
     * Get the expirationTime property: Certificate expiration time.
     * 
     * @return the expirationTime value.
     */
    public OffsetDateTime expirationTime() {
        return this.expirationTime;
    }

    /**
     * Get the isPrivateKeyExternal property: &lt;code&gt;true&lt;/code&gt; if private key is external; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     * 
     * @return the isPrivateKeyExternal value.
     */
    public Boolean isPrivateKeyExternal() {
        return this.isPrivateKeyExternal;
    }

    /**
     * Get the appServiceCertificateNotRenewableReasons property: Reasons why App Service Certificate is not renewable
     * at the current moment.
     * 
     * @return the appServiceCertificateNotRenewableReasons value.
     */
    public List<ResourceNotRenewableReason> appServiceCertificateNotRenewableReasons() {
        return this.appServiceCertificateNotRenewableReasons;
    }

    /**
     * Get the nextAutoRenewalTimestamp property: Time stamp when the certificate would be auto renewed next.
     * 
     * @return the nextAutoRenewalTimestamp value.
     */
    public OffsetDateTime nextAutoRenewalTimestamp() {
        return this.nextAutoRenewalTimestamp;
    }

    /**
     * Get the contact property: Contact info.
     * 
     * @return the contact value.
     */
    public CertificateOrderContact contact() {
        return this.contact;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (certificates() != null) {
            certificates().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (productType() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property productType in model AppServiceCertificateOrderPatchResourceProperties"));
        }
        if (signedCertificate() != null) {
            signedCertificate().validate();
        }
        if (intermediate() != null) {
            intermediate().validate();
        }
        if (root() != null) {
            root().validate();
        }
        if (contact() != null) {
            contact().validate();
        }
    }

    private static final ClientLogger LOGGER
        = new ClientLogger(AppServiceCertificateOrderPatchResourceProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("productType", this.productType == null ? null : this.productType.toString());
        jsonWriter.writeMapField("certificates", this.certificates, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("distinguishedName", this.distinguishedName);
        jsonWriter.writeNumberField("validityInYears", this.validityInYears);
        jsonWriter.writeNumberField("keySize", this.keySize);
        jsonWriter.writeBooleanField("autoRenew", this.autoRenew);
        jsonWriter.writeStringField("csr", this.csr);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AppServiceCertificateOrderPatchResourceProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AppServiceCertificateOrderPatchResourceProperties if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AppServiceCertificateOrderPatchResourceProperties.
     */
    public static AppServiceCertificateOrderPatchResourceProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AppServiceCertificateOrderPatchResourceProperties deserializedAppServiceCertificateOrderPatchResourceProperties
                = new AppServiceCertificateOrderPatchResourceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("productType".equals(fieldName)) {
                    deserializedAppServiceCertificateOrderPatchResourceProperties.productType
                        = CertificateProductType.fromString(reader.getString());
                } else if ("certificates".equals(fieldName)) {
                    Map<String, AppServiceCertificateInner> certificates
                        = reader.readMap(reader1 -> AppServiceCertificateInner.fromJson(reader1));
                    deserializedAppServiceCertificateOrderPatchResourceProperties.certificates = certificates;
                } else if ("distinguishedName".equals(fieldName)) {
                    deserializedAppServiceCertificateOrderPatchResourceProperties.distinguishedName
                        = reader.getString();
                } else if ("domainVerificationToken".equals(fieldName)) {
                    deserializedAppServiceCertificateOrderPatchResourceProperties.domainVerificationToken
                        = reader.getString();
                } else if ("validityInYears".equals(fieldName)) {
                    deserializedAppServiceCertificateOrderPatchResourceProperties.validityInYears
                        = reader.getNullable(JsonReader::getInt);
                } else if ("keySize".equals(fieldName)) {
                    deserializedAppServiceCertificateOrderPatchResourceProperties.keySize
                        = reader.getNullable(JsonReader::getInt);
                } else if ("autoRenew".equals(fieldName)) {
                    deserializedAppServiceCertificateOrderPatchResourceProperties.autoRenew
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedAppServiceCertificateOrderPatchResourceProperties.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else if ("status".equals(fieldName)) {
                    deserializedAppServiceCertificateOrderPatchResourceProperties.status
                        = CertificateOrderStatus.fromString(reader.getString());
                } else if ("signedCertificate".equals(fieldName)) {
                    deserializedAppServiceCertificateOrderPatchResourceProperties.signedCertificate
                        = CertificateDetails.fromJson(reader);
                } else if ("csr".equals(fieldName)) {
                    deserializedAppServiceCertificateOrderPatchResourceProperties.csr = reader.getString();
                } else if ("intermediate".equals(fieldName)) {
                    deserializedAppServiceCertificateOrderPatchResourceProperties.intermediate
                        = CertificateDetails.fromJson(reader);
                } else if ("root".equals(fieldName)) {
                    deserializedAppServiceCertificateOrderPatchResourceProperties.root
                        = CertificateDetails.fromJson(reader);
                } else if ("serialNumber".equals(fieldName)) {
                    deserializedAppServiceCertificateOrderPatchResourceProperties.serialNumber = reader.getString();
                } else if ("lastCertificateIssuanceTime".equals(fieldName)) {
                    deserializedAppServiceCertificateOrderPatchResourceProperties.lastCertificateIssuanceTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("expirationTime".equals(fieldName)) {
                    deserializedAppServiceCertificateOrderPatchResourceProperties.expirationTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("isPrivateKeyExternal".equals(fieldName)) {
                    deserializedAppServiceCertificateOrderPatchResourceProperties.isPrivateKeyExternal
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("appServiceCertificateNotRenewableReasons".equals(fieldName)) {
                    List<ResourceNotRenewableReason> appServiceCertificateNotRenewableReasons
                        = reader.readArray(reader1 -> ResourceNotRenewableReason.fromString(reader1.getString()));
                    deserializedAppServiceCertificateOrderPatchResourceProperties.appServiceCertificateNotRenewableReasons
                        = appServiceCertificateNotRenewableReasons;
                } else if ("nextAutoRenewalTimeStamp".equals(fieldName)) {
                    deserializedAppServiceCertificateOrderPatchResourceProperties.nextAutoRenewalTimestamp = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("contact".equals(fieldName)) {
                    deserializedAppServiceCertificateOrderPatchResourceProperties.contact
                        = CertificateOrderContact.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAppServiceCertificateOrderPatchResourceProperties;
        });
    }
}
