/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.RevisionInner;
import java.io.IOException;
import java.util.List;

public final class RevisionCollection
implements JsonSerializable<RevisionCollection> {
    private List<RevisionInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(RevisionCollection.class);

    public List<RevisionInner> value() {
        return this.value;
    }

    public RevisionCollection withValue(List<RevisionInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model RevisionCollection"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static RevisionCollection fromJson(JsonReader jsonReader) throws IOException {
        return (RevisionCollection)jsonReader.readObject(reader -> {
            RevisionCollection deserializedRevisionCollection = new RevisionCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedRevisionCollection.value = value = reader.readArray(reader1 -> RevisionInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedRevisionCollection.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRevisionCollection;
        });
    }
}

