/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.ScaleRuleAuth;
import java.io.IOException;
import java.util.List;

public final class QueueScaleRule
implements JsonSerializable<QueueScaleRule> {
    private String queueName;
    private Integer queueLength;
    private List<ScaleRuleAuth> auth;

    public String queueName() {
        return this.queueName;
    }

    public QueueScaleRule withQueueName(String queueName) {
        this.queueName = queueName;
        return this;
    }

    public Integer queueLength() {
        return this.queueLength;
    }

    public QueueScaleRule withQueueLength(Integer queueLength) {
        this.queueLength = queueLength;
        return this;
    }

    public List<ScaleRuleAuth> auth() {
        return this.auth;
    }

    public QueueScaleRule withAuth(List<ScaleRuleAuth> auth) {
        this.auth = auth;
        return this;
    }

    public void validate() {
        if (this.auth() != null) {
            this.auth().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("queueName", this.queueName);
        jsonWriter.writeNumberField("queueLength", (Number)this.queueLength);
        jsonWriter.writeArrayField("auth", this.auth, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static QueueScaleRule fromJson(JsonReader jsonReader) throws IOException {
        return (QueueScaleRule)jsonReader.readObject(reader -> {
            QueueScaleRule deserializedQueueScaleRule = new QueueScaleRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("queueName".equals(fieldName)) {
                    deserializedQueueScaleRule.queueName = reader.getString();
                    continue;
                }
                if ("queueLength".equals(fieldName)) {
                    deserializedQueueScaleRule.queueLength = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("auth".equals(fieldName)) {
                    List auth;
                    deserializedQueueScaleRule.auth = auth = reader.readArray(reader1 -> ScaleRuleAuth.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedQueueScaleRule;
        });
    }
}

