/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.RunActionCorrelation;
import com.azure.resourcemanager.appservice.models.WorkflowStatus;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public class OperationResultProperties
implements JsonSerializable<OperationResultProperties> {
    private OffsetDateTime startTime;
    private OffsetDateTime endTime;
    private RunActionCorrelation correlation;
    private WorkflowStatus status;
    private String code;
    private Object error;

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public OperationResultProperties withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    public OperationResultProperties withEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    public RunActionCorrelation correlation() {
        return this.correlation;
    }

    public OperationResultProperties withCorrelation(RunActionCorrelation correlation) {
        this.correlation = correlation;
        return this;
    }

    public WorkflowStatus status() {
        return this.status;
    }

    public OperationResultProperties withStatus(WorkflowStatus status) {
        this.status = status;
        return this;
    }

    public String code() {
        return this.code;
    }

    public OperationResultProperties withCode(String code) {
        this.code = code;
        return this;
    }

    public Object error() {
        return this.error;
    }

    public OperationResultProperties withError(Object error) {
        this.error = error;
        return this;
    }

    public void validate() {
        if (this.correlation() != null) {
            this.correlation().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("startTime", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("endTime", this.endTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endTime));
        jsonWriter.writeJsonField("correlation", (JsonSerializable)this.correlation);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("code", this.code);
        jsonWriter.writeUntypedField("error", this.error);
        return jsonWriter.writeEndObject();
    }

    public static OperationResultProperties fromJson(JsonReader jsonReader) throws IOException {
        return (OperationResultProperties)jsonReader.readObject(reader -> {
            OperationResultProperties deserializedOperationResultProperties = new OperationResultProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("startTime".equals(fieldName)) {
                    deserializedOperationResultProperties.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedOperationResultProperties.endTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("correlation".equals(fieldName)) {
                    deserializedOperationResultProperties.correlation = RunActionCorrelation.fromJson(reader);
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedOperationResultProperties.status = WorkflowStatus.fromString(reader.getString());
                    continue;
                }
                if ("code".equals(fieldName)) {
                    deserializedOperationResultProperties.code = reader.getString();
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedOperationResultProperties.error = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOperationResultProperties;
        });
    }
}

