/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.ContainerResources;
import com.azure.resourcemanager.appservice.models.EnvironmentVar;
import java.io.IOException;
import java.util.List;

public final class Container
implements JsonSerializable<Container> {
    private String image;
    private String name;
    private List<String> command;
    private List<String> args;
    private List<EnvironmentVar> env;
    private ContainerResources resources;

    public String image() {
        return this.image;
    }

    public Container withImage(String image) {
        this.image = image;
        return this;
    }

    public String name() {
        return this.name;
    }

    public Container withName(String name) {
        this.name = name;
        return this;
    }

    public List<String> command() {
        return this.command;
    }

    public Container withCommand(List<String> command) {
        this.command = command;
        return this;
    }

    public List<String> args() {
        return this.args;
    }

    public Container withArgs(List<String> args) {
        this.args = args;
        return this;
    }

    public List<EnvironmentVar> env() {
        return this.env;
    }

    public Container withEnv(List<EnvironmentVar> env) {
        this.env = env;
        return this;
    }

    public ContainerResources resources() {
        return this.resources;
    }

    public Container withResources(ContainerResources resources) {
        this.resources = resources;
        return this;
    }

    public void validate() {
        if (this.env() != null) {
            this.env().forEach(e -> e.validate());
        }
        if (this.resources() != null) {
            this.resources().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("image", this.image);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeArrayField("command", this.command, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("args", this.args, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("env", this.env, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("resources", (JsonSerializable)this.resources);
        return jsonWriter.writeEndObject();
    }

    public static Container fromJson(JsonReader jsonReader) throws IOException {
        return (Container)jsonReader.readObject(reader -> {
            Container deserializedContainer = new Container();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("image".equals(fieldName)) {
                    deserializedContainer.image = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedContainer.name = reader.getString();
                    continue;
                }
                if ("command".equals(fieldName)) {
                    List command;
                    deserializedContainer.command = command = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("args".equals(fieldName)) {
                    List args;
                    deserializedContainer.args = args = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("env".equals(fieldName)) {
                    List env;
                    deserializedContainer.env = env = reader.readArray(reader1 -> EnvironmentVar.fromJson(reader1));
                    continue;
                }
                if ("resources".equals(fieldName)) {
                    deserializedContainer.resources = ContainerResources.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContainer;
        });
    }
}

