/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.MSDeployProvisioningState;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class MSDeployStatusProperties
implements JsonSerializable<MSDeployStatusProperties> {
    private String deployer;
    private MSDeployProvisioningState provisioningState;
    private OffsetDateTime startTime;
    private OffsetDateTime endTime;
    private Boolean complete;

    public String deployer() {
        return this.deployer;
    }

    public MSDeployProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    public Boolean complete() {
        return this.complete;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static MSDeployStatusProperties fromJson(JsonReader jsonReader) throws IOException {
        return (MSDeployStatusProperties)jsonReader.readObject(reader -> {
            MSDeployStatusProperties deserializedMSDeployStatusProperties = new MSDeployStatusProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("deployer".equals(fieldName)) {
                    deserializedMSDeployStatusProperties.deployer = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedMSDeployStatusProperties.provisioningState = MSDeployProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedMSDeployStatusProperties.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedMSDeployStatusProperties.endTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("complete".equals(fieldName)) {
                    deserializedMSDeployStatusProperties.complete = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMSDeployStatusProperties;
        });
    }
}

