/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.SkuInfoInner;
import java.io.IOException;
import java.util.List;

public final class SkuInfoCollection
implements JsonSerializable<SkuInfoCollection> {
    private List<SkuInfoInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(SkuInfoCollection.class);

    public List<SkuInfoInner> value() {
        return this.value;
    }

    public SkuInfoCollection withValue(List<SkuInfoInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model SkuInfoCollection"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SkuInfoCollection fromJson(JsonReader jsonReader) throws IOException {
        return (SkuInfoCollection)jsonReader.readObject(reader -> {
            SkuInfoCollection deserializedSkuInfoCollection = new SkuInfoCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedSkuInfoCollection.value = value = reader.readArray(reader1 -> SkuInfoInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedSkuInfoCollection.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSkuInfoCollection;
        });
    }
}

