/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.management.exception.ManagementError;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class RetryHistory
implements JsonSerializable<RetryHistory> {
    private OffsetDateTime startTime;
    private OffsetDateTime endTime;
    private String code;
    private String clientRequestId;
    private String serviceRequestId;
    private ManagementError error;

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public RetryHistory withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    public RetryHistory withEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    public String code() {
        return this.code;
    }

    public RetryHistory withCode(String code) {
        this.code = code;
        return this;
    }

    public String clientRequestId() {
        return this.clientRequestId;
    }

    public RetryHistory withClientRequestId(String clientRequestId) {
        this.clientRequestId = clientRequestId;
        return this;
    }

    public String serviceRequestId() {
        return this.serviceRequestId;
    }

    public RetryHistory withServiceRequestId(String serviceRequestId) {
        this.serviceRequestId = serviceRequestId;
        return this;
    }

    public ManagementError error() {
        return this.error;
    }

    public RetryHistory withError(ManagementError error) {
        this.error = error;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("startTime", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("endTime", this.endTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endTime));
        jsonWriter.writeStringField("code", this.code);
        jsonWriter.writeStringField("clientRequestId", this.clientRequestId);
        jsonWriter.writeStringField("serviceRequestId", this.serviceRequestId);
        jsonWriter.writeJsonField("error", (JsonSerializable)this.error);
        return jsonWriter.writeEndObject();
    }

    public static RetryHistory fromJson(JsonReader jsonReader) throws IOException {
        return (RetryHistory)jsonReader.readObject(reader -> {
            RetryHistory deserializedRetryHistory = new RetryHistory();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("startTime".equals(fieldName)) {
                    deserializedRetryHistory.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedRetryHistory.endTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("code".equals(fieldName)) {
                    deserializedRetryHistory.code = reader.getString();
                    continue;
                }
                if ("clientRequestId".equals(fieldName)) {
                    deserializedRetryHistory.clientRequestId = reader.getString();
                    continue;
                }
                if ("serviceRequestId".equals(fieldName)) {
                    deserializedRetryHistory.serviceRequestId = reader.getString();
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedRetryHistory.error = ManagementError.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRetryHistory;
        });
    }
}

