// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.WorkerPoolResourceInner;
import java.io.IOException;
import java.util.List;

/**
 * Collection of worker pools.
 */
@Fluent
public final class WorkerPoolCollection implements JsonSerializable<WorkerPoolCollection> {
    /*
     * Collection of resources.
     */
    private List<WorkerPoolResourceInner> value;

    /*
     * Link to next page of resources.
     */
    private String nextLink;

    /**
     * Creates an instance of WorkerPoolCollection class.
     */
    public WorkerPoolCollection() {
    }

    /**
     * Get the value property: Collection of resources.
     * 
     * @return the value value.
     */
    public List<WorkerPoolResourceInner> value() {
        return this.value;
    }

    /**
     * Set the value property: Collection of resources.
     * 
     * @param value the value value to set.
     * @return the WorkerPoolCollection object itself.
     */
    public WorkerPoolCollection withValue(List<WorkerPoolResourceInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: Link to next page of resources.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property value in model WorkerPoolCollection"));
        } else {
            value().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(WorkerPoolCollection.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WorkerPoolCollection from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WorkerPoolCollection if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the WorkerPoolCollection.
     */
    public static WorkerPoolCollection fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WorkerPoolCollection deserializedWorkerPoolCollection = new WorkerPoolCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<WorkerPoolResourceInner> value
                        = reader.readArray(reader1 -> WorkerPoolResourceInner.fromJson(reader1));
                    deserializedWorkerPoolCollection.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedWorkerPoolCollection.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedWorkerPoolCollection;
        });
    }
}
