// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

/**
 * Defines values for StorageType.
 */
public enum StorageType {
    /**
     * Enum value LocalNode.
     */
    LOCAL_NODE("LocalNode"),

    /**
     * Enum value NetworkFileSystem.
     */
    NETWORK_FILE_SYSTEM("NetworkFileSystem");

    /**
     * The actual serialized value for a StorageType instance.
     */
    private final String value;

    StorageType(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a StorageType instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed StorageType object, or null if unable to parse.
     */
    public static StorageType fromString(String value) {
        if (value == null) {
            return null;
        }
        StorageType[] items = StorageType.values();
        for (StorageType item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
