// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The ip address range.
 */
@Fluent
public final class IpAddressRange implements JsonSerializable<IpAddressRange> {
    /*
     * The IP address range.
     */
    private String addressRange;

    /**
     * Creates an instance of IpAddressRange class.
     */
    public IpAddressRange() {
    }

    /**
     * Get the addressRange property: The IP address range.
     * 
     * @return the addressRange value.
     */
    public String addressRange() {
        return this.addressRange;
    }

    /**
     * Set the addressRange property: The IP address range.
     * 
     * @param addressRange the addressRange value to set.
     * @return the IpAddressRange object itself.
     */
    public IpAddressRange withAddressRange(String addressRange) {
        this.addressRange = addressRange;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("addressRange", this.addressRange);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of IpAddressRange from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of IpAddressRange if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the IpAddressRange.
     */
    public static IpAddressRange fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            IpAddressRange deserializedIpAddressRange = new IpAddressRange();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("addressRange".equals(fieldName)) {
                    deserializedIpAddressRange.addressRange = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedIpAddressRange;
        });
    }
}
