// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Object with a list of the resources that need to be moved and the resource group they should be moved to.
 */
@Fluent
public final class CsmMoveResourceEnvelope implements JsonSerializable<CsmMoveResourceEnvelope> {
    /*
     * The targetResourceGroup property.
     */
    private String targetResourceGroup;

    /*
     * The resources property.
     */
    private List<String> resources;

    /**
     * Creates an instance of CsmMoveResourceEnvelope class.
     */
    public CsmMoveResourceEnvelope() {
    }

    /**
     * Get the targetResourceGroup property: The targetResourceGroup property.
     * 
     * @return the targetResourceGroup value.
     */
    public String targetResourceGroup() {
        return this.targetResourceGroup;
    }

    /**
     * Set the targetResourceGroup property: The targetResourceGroup property.
     * 
     * @param targetResourceGroup the targetResourceGroup value to set.
     * @return the CsmMoveResourceEnvelope object itself.
     */
    public CsmMoveResourceEnvelope withTargetResourceGroup(String targetResourceGroup) {
        this.targetResourceGroup = targetResourceGroup;
        return this;
    }

    /**
     * Get the resources property: The resources property.
     * 
     * @return the resources value.
     */
    public List<String> resources() {
        return this.resources;
    }

    /**
     * Set the resources property: The resources property.
     * 
     * @param resources the resources value to set.
     * @return the CsmMoveResourceEnvelope object itself.
     */
    public CsmMoveResourceEnvelope withResources(List<String> resources) {
        this.resources = resources;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("targetResourceGroup", this.targetResourceGroup);
        jsonWriter.writeArrayField("resources", this.resources, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CsmMoveResourceEnvelope from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CsmMoveResourceEnvelope if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CsmMoveResourceEnvelope.
     */
    public static CsmMoveResourceEnvelope fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CsmMoveResourceEnvelope deserializedCsmMoveResourceEnvelope = new CsmMoveResourceEnvelope();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("targetResourceGroup".equals(fieldName)) {
                    deserializedCsmMoveResourceEnvelope.targetResourceGroup = reader.getString();
                } else if ("resources".equals(fieldName)) {
                    List<String> resources = reader.readArray(reader1 -> reader1.getString());
                    deserializedCsmMoveResourceEnvelope.resources = resources;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCsmMoveResourceEnvelope;
        });
    }
}
