// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The ContainerCpuUsage model.
 */
@Fluent
public final class ContainerCpuUsage implements JsonSerializable<ContainerCpuUsage> {
    /*
     * The totalUsage property.
     */
    private Long totalUsage;

    /*
     * The perCpuUsage property.
     */
    private List<Long> perCpuUsage;

    /*
     * The kernelModeUsage property.
     */
    private Long kernelModeUsage;

    /*
     * The userModeUsage property.
     */
    private Long userModeUsage;

    /**
     * Creates an instance of ContainerCpuUsage class.
     */
    public ContainerCpuUsage() {
    }

    /**
     * Get the totalUsage property: The totalUsage property.
     * 
     * @return the totalUsage value.
     */
    public Long totalUsage() {
        return this.totalUsage;
    }

    /**
     * Set the totalUsage property: The totalUsage property.
     * 
     * @param totalUsage the totalUsage value to set.
     * @return the ContainerCpuUsage object itself.
     */
    public ContainerCpuUsage withTotalUsage(Long totalUsage) {
        this.totalUsage = totalUsage;
        return this;
    }

    /**
     * Get the perCpuUsage property: The perCpuUsage property.
     * 
     * @return the perCpuUsage value.
     */
    public List<Long> perCpuUsage() {
        return this.perCpuUsage;
    }

    /**
     * Set the perCpuUsage property: The perCpuUsage property.
     * 
     * @param perCpuUsage the perCpuUsage value to set.
     * @return the ContainerCpuUsage object itself.
     */
    public ContainerCpuUsage withPerCpuUsage(List<Long> perCpuUsage) {
        this.perCpuUsage = perCpuUsage;
        return this;
    }

    /**
     * Get the kernelModeUsage property: The kernelModeUsage property.
     * 
     * @return the kernelModeUsage value.
     */
    public Long kernelModeUsage() {
        return this.kernelModeUsage;
    }

    /**
     * Set the kernelModeUsage property: The kernelModeUsage property.
     * 
     * @param kernelModeUsage the kernelModeUsage value to set.
     * @return the ContainerCpuUsage object itself.
     */
    public ContainerCpuUsage withKernelModeUsage(Long kernelModeUsage) {
        this.kernelModeUsage = kernelModeUsage;
        return this;
    }

    /**
     * Get the userModeUsage property: The userModeUsage property.
     * 
     * @return the userModeUsage value.
     */
    public Long userModeUsage() {
        return this.userModeUsage;
    }

    /**
     * Set the userModeUsage property: The userModeUsage property.
     * 
     * @param userModeUsage the userModeUsage value to set.
     * @return the ContainerCpuUsage object itself.
     */
    public ContainerCpuUsage withUserModeUsage(Long userModeUsage) {
        this.userModeUsage = userModeUsage;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("totalUsage", this.totalUsage);
        jsonWriter.writeArrayField("perCpuUsage", this.perCpuUsage, (writer, element) -> writer.writeLong(element));
        jsonWriter.writeNumberField("kernelModeUsage", this.kernelModeUsage);
        jsonWriter.writeNumberField("userModeUsage", this.userModeUsage);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ContainerCpuUsage from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ContainerCpuUsage if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ContainerCpuUsage.
     */
    public static ContainerCpuUsage fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ContainerCpuUsage deserializedContainerCpuUsage = new ContainerCpuUsage();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("totalUsage".equals(fieldName)) {
                    deserializedContainerCpuUsage.totalUsage = reader.getNullable(JsonReader::getLong);
                } else if ("perCpuUsage".equals(fieldName)) {
                    List<Long> perCpuUsage = reader.readArray(reader1 -> reader1.getLong());
                    deserializedContainerCpuUsage.perCpuUsage = perCpuUsage;
                } else if ("kernelModeUsage".equals(fieldName)) {
                    deserializedContainerCpuUsage.kernelModeUsage = reader.getNullable(JsonReader::getLong);
                } else if ("userModeUsage".equals(fieldName)) {
                    deserializedContainerCpuUsage.userModeUsage = reader.getNullable(JsonReader::getLong);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedContainerCpuUsage;
        });
    }
}
