// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Application logs azure blob storage configuration.
 */
@Fluent
public final class AzureBlobStorageApplicationLogsConfig
    implements JsonSerializable<AzureBlobStorageApplicationLogsConfig> {
    /*
     * Log level.
     */
    private LogLevel level;

    /*
     * SAS url to a azure blob container with read/write/list/delete permissions.
     */
    private String sasUrl;

    /*
     * Retention in days.
     * Remove blobs older than X days.
     * 0 or lower means no retention.
     */
    private Integer retentionInDays;

    /**
     * Creates an instance of AzureBlobStorageApplicationLogsConfig class.
     */
    public AzureBlobStorageApplicationLogsConfig() {
    }

    /**
     * Get the level property: Log level.
     * 
     * @return the level value.
     */
    public LogLevel level() {
        return this.level;
    }

    /**
     * Set the level property: Log level.
     * 
     * @param level the level value to set.
     * @return the AzureBlobStorageApplicationLogsConfig object itself.
     */
    public AzureBlobStorageApplicationLogsConfig withLevel(LogLevel level) {
        this.level = level;
        return this;
    }

    /**
     * Get the sasUrl property: SAS url to a azure blob container with read/write/list/delete permissions.
     * 
     * @return the sasUrl value.
     */
    public String sasUrl() {
        return this.sasUrl;
    }

    /**
     * Set the sasUrl property: SAS url to a azure blob container with read/write/list/delete permissions.
     * 
     * @param sasUrl the sasUrl value to set.
     * @return the AzureBlobStorageApplicationLogsConfig object itself.
     */
    public AzureBlobStorageApplicationLogsConfig withSasUrl(String sasUrl) {
        this.sasUrl = sasUrl;
        return this;
    }

    /**
     * Get the retentionInDays property: Retention in days.
     * Remove blobs older than X days.
     * 0 or lower means no retention.
     * 
     * @return the retentionInDays value.
     */
    public Integer retentionInDays() {
        return this.retentionInDays;
    }

    /**
     * Set the retentionInDays property: Retention in days.
     * Remove blobs older than X days.
     * 0 or lower means no retention.
     * 
     * @param retentionInDays the retentionInDays value to set.
     * @return the AzureBlobStorageApplicationLogsConfig object itself.
     */
    public AzureBlobStorageApplicationLogsConfig withRetentionInDays(Integer retentionInDays) {
        this.retentionInDays = retentionInDays;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("level", this.level == null ? null : this.level.toString());
        jsonWriter.writeStringField("sasUrl", this.sasUrl);
        jsonWriter.writeNumberField("retentionInDays", this.retentionInDays);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AzureBlobStorageApplicationLogsConfig from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AzureBlobStorageApplicationLogsConfig if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AzureBlobStorageApplicationLogsConfig.
     */
    public static AzureBlobStorageApplicationLogsConfig fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AzureBlobStorageApplicationLogsConfig deserializedAzureBlobStorageApplicationLogsConfig
                = new AzureBlobStorageApplicationLogsConfig();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("level".equals(fieldName)) {
                    deserializedAzureBlobStorageApplicationLogsConfig.level = LogLevel.fromString(reader.getString());
                } else if ("sasUrl".equals(fieldName)) {
                    deserializedAzureBlobStorageApplicationLogsConfig.sasUrl = reader.getString();
                } else if ("retentionInDays".equals(fieldName)) {
                    deserializedAzureBlobStorageApplicationLogsConfig.retentionInDays
                        = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAzureBlobStorageApplicationLogsConfig;
        });
    }
}
