// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * StorageMigrationResponse resource specific properties.
 */
@Immutable
public final class StorageMigrationResponseProperties implements JsonSerializable<StorageMigrationResponseProperties> {
    /*
     * When server starts the migration process, it will return an operation ID identifying that particular migration
     * operation.
     */
    private String operationId;

    /**
     * Creates an instance of StorageMigrationResponseProperties class.
     */
    public StorageMigrationResponseProperties() {
    }

    /**
     * Get the operationId property: When server starts the migration process, it will return an operation ID
     * identifying that particular migration operation.
     * 
     * @return the operationId value.
     */
    public String operationId() {
        return this.operationId;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StorageMigrationResponseProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of StorageMigrationResponseProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the StorageMigrationResponseProperties.
     */
    public static StorageMigrationResponseProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StorageMigrationResponseProperties deserializedStorageMigrationResponseProperties
                = new StorageMigrationResponseProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("operationId".equals(fieldName)) {
                    deserializedStorageMigrationResponseProperties.operationId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedStorageMigrationResponseProperties;
        });
    }
}
