// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import java.io.IOException;

/**
 * Publishing Credentials Policies parameters.
 */
@Fluent
public final class CsmPublishingCredentialsPoliciesEntityInner extends ProxyOnlyResource {
    /*
     * CsmPublishingCredentialsPoliciesEntity resource specific properties
     */
    private CsmPublishingCredentialsPoliciesEntityProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of CsmPublishingCredentialsPoliciesEntityInner class.
     */
    public CsmPublishingCredentialsPoliciesEntityInner() {
    }

    /**
     * Get the innerProperties property: CsmPublishingCredentialsPoliciesEntity resource specific properties.
     * 
     * @return the innerProperties value.
     */
    private CsmPublishingCredentialsPoliciesEntityProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public CsmPublishingCredentialsPoliciesEntityInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the allow property: &lt;code&gt;true&lt;/code&gt; to allow access to a publishing method; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     * 
     * @return the allow value.
     */
    public Boolean allow() {
        return this.innerProperties() == null ? null : this.innerProperties().allow();
    }

    /**
     * Set the allow property: &lt;code&gt;true&lt;/code&gt; to allow access to a publishing method; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     * 
     * @param allow the allow value to set.
     * @return the CsmPublishingCredentialsPoliciesEntityInner object itself.
     */
    public CsmPublishingCredentialsPoliciesEntityInner withAllow(Boolean allow) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CsmPublishingCredentialsPoliciesEntityProperties();
        }
        this.innerProperties().withAllow(allow);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", kind());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CsmPublishingCredentialsPoliciesEntityInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CsmPublishingCredentialsPoliciesEntityInner if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the CsmPublishingCredentialsPoliciesEntityInner.
     */
    public static CsmPublishingCredentialsPoliciesEntityInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CsmPublishingCredentialsPoliciesEntityInner deserializedCsmPublishingCredentialsPoliciesEntityInner
                = new CsmPublishingCredentialsPoliciesEntityInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedCsmPublishingCredentialsPoliciesEntityInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedCsmPublishingCredentialsPoliciesEntityInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedCsmPublishingCredentialsPoliciesEntityInner.type = reader.getString();
                } else if ("kind".equals(fieldName)) {
                    deserializedCsmPublishingCredentialsPoliciesEntityInner.withKind(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedCsmPublishingCredentialsPoliciesEntityInner.innerProperties
                        = CsmPublishingCredentialsPoliciesEntityProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCsmPublishingCredentialsPoliciesEntityInner;
        });
    }
}
