// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.ConfigReferenceSource;
import com.azure.resourcemanager.appservice.models.ManagedServiceIdentity;
import com.azure.resourcemanager.appservice.models.ResolveStatus;
import java.io.IOException;

/**
 * ApiKVReference resource specific properties.
 */
@Fluent
public final class ApiKVReferenceProperties implements JsonSerializable<ApiKVReferenceProperties> {
    /*
     * The reference property.
     */
    private String reference;

    /*
     * The status property.
     */
    private ResolveStatus status;

    /*
     * The vaultName property.
     */
    private String vaultName;

    /*
     * The secretName property.
     */
    private String secretName;

    /*
     * The secretVersion property.
     */
    private String secretVersion;

    /*
     * Managed service identity.
     */
    private ManagedServiceIdentity identityType;

    /*
     * The details property.
     */
    private String details;

    /*
     * The source property.
     */
    private ConfigReferenceSource source;

    /*
     * The activeVersion property.
     */
    private String activeVersion;

    /**
     * Creates an instance of ApiKVReferenceProperties class.
     */
    public ApiKVReferenceProperties() {
    }

    /**
     * Get the reference property: The reference property.
     * 
     * @return the reference value.
     */
    public String reference() {
        return this.reference;
    }

    /**
     * Set the reference property: The reference property.
     * 
     * @param reference the reference value to set.
     * @return the ApiKVReferenceProperties object itself.
     */
    public ApiKVReferenceProperties withReference(String reference) {
        this.reference = reference;
        return this;
    }

    /**
     * Get the status property: The status property.
     * 
     * @return the status value.
     */
    public ResolveStatus status() {
        return this.status;
    }

    /**
     * Set the status property: The status property.
     * 
     * @param status the status value to set.
     * @return the ApiKVReferenceProperties object itself.
     */
    public ApiKVReferenceProperties withStatus(ResolveStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Get the vaultName property: The vaultName property.
     * 
     * @return the vaultName value.
     */
    public String vaultName() {
        return this.vaultName;
    }

    /**
     * Set the vaultName property: The vaultName property.
     * 
     * @param vaultName the vaultName value to set.
     * @return the ApiKVReferenceProperties object itself.
     */
    public ApiKVReferenceProperties withVaultName(String vaultName) {
        this.vaultName = vaultName;
        return this;
    }

    /**
     * Get the secretName property: The secretName property.
     * 
     * @return the secretName value.
     */
    public String secretName() {
        return this.secretName;
    }

    /**
     * Set the secretName property: The secretName property.
     * 
     * @param secretName the secretName value to set.
     * @return the ApiKVReferenceProperties object itself.
     */
    public ApiKVReferenceProperties withSecretName(String secretName) {
        this.secretName = secretName;
        return this;
    }

    /**
     * Get the secretVersion property: The secretVersion property.
     * 
     * @return the secretVersion value.
     */
    public String secretVersion() {
        return this.secretVersion;
    }

    /**
     * Set the secretVersion property: The secretVersion property.
     * 
     * @param secretVersion the secretVersion value to set.
     * @return the ApiKVReferenceProperties object itself.
     */
    public ApiKVReferenceProperties withSecretVersion(String secretVersion) {
        this.secretVersion = secretVersion;
        return this;
    }

    /**
     * Get the identityType property: Managed service identity.
     * 
     * @return the identityType value.
     */
    public ManagedServiceIdentity identityType() {
        return this.identityType;
    }

    /**
     * Set the identityType property: Managed service identity.
     * 
     * @param identityType the identityType value to set.
     * @return the ApiKVReferenceProperties object itself.
     */
    public ApiKVReferenceProperties withIdentityType(ManagedServiceIdentity identityType) {
        this.identityType = identityType;
        return this;
    }

    /**
     * Get the details property: The details property.
     * 
     * @return the details value.
     */
    public String details() {
        return this.details;
    }

    /**
     * Set the details property: The details property.
     * 
     * @param details the details value to set.
     * @return the ApiKVReferenceProperties object itself.
     */
    public ApiKVReferenceProperties withDetails(String details) {
        this.details = details;
        return this;
    }

    /**
     * Get the source property: The source property.
     * 
     * @return the source value.
     */
    public ConfigReferenceSource source() {
        return this.source;
    }

    /**
     * Set the source property: The source property.
     * 
     * @param source the source value to set.
     * @return the ApiKVReferenceProperties object itself.
     */
    public ApiKVReferenceProperties withSource(ConfigReferenceSource source) {
        this.source = source;
        return this;
    }

    /**
     * Get the activeVersion property: The activeVersion property.
     * 
     * @return the activeVersion value.
     */
    public String activeVersion() {
        return this.activeVersion;
    }

    /**
     * Set the activeVersion property: The activeVersion property.
     * 
     * @param activeVersion the activeVersion value to set.
     * @return the ApiKVReferenceProperties object itself.
     */
    public ApiKVReferenceProperties withActiveVersion(String activeVersion) {
        this.activeVersion = activeVersion;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (identityType() != null) {
            identityType().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("reference", this.reference);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("vaultName", this.vaultName);
        jsonWriter.writeStringField("secretName", this.secretName);
        jsonWriter.writeStringField("secretVersion", this.secretVersion);
        jsonWriter.writeJsonField("identityType", this.identityType);
        jsonWriter.writeStringField("details", this.details);
        jsonWriter.writeStringField("source", this.source == null ? null : this.source.toString());
        jsonWriter.writeStringField("activeVersion", this.activeVersion);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApiKVReferenceProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApiKVReferenceProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApiKVReferenceProperties.
     */
    public static ApiKVReferenceProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApiKVReferenceProperties deserializedApiKVReferenceProperties = new ApiKVReferenceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("reference".equals(fieldName)) {
                    deserializedApiKVReferenceProperties.reference = reader.getString();
                } else if ("status".equals(fieldName)) {
                    deserializedApiKVReferenceProperties.status = ResolveStatus.fromString(reader.getString());
                } else if ("vaultName".equals(fieldName)) {
                    deserializedApiKVReferenceProperties.vaultName = reader.getString();
                } else if ("secretName".equals(fieldName)) {
                    deserializedApiKVReferenceProperties.secretName = reader.getString();
                } else if ("secretVersion".equals(fieldName)) {
                    deserializedApiKVReferenceProperties.secretVersion = reader.getString();
                } else if ("identityType".equals(fieldName)) {
                    deserializedApiKVReferenceProperties.identityType = ManagedServiceIdentity.fromJson(reader);
                } else if ("details".equals(fieldName)) {
                    deserializedApiKVReferenceProperties.details = reader.getString();
                } else if ("source".equals(fieldName)) {
                    deserializedApiKVReferenceProperties.source = ConfigReferenceSource.fromString(reader.getString());
                } else if ("activeVersion".equals(fieldName)) {
                    deserializedApiKVReferenceProperties.activeVersion = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApiKVReferenceProperties;
        });
    }
}
