/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.Channels;
import com.azure.resourcemanager.appservice.models.NotificationLevel;
import com.azure.resourcemanager.appservice.models.ResourceScopeType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public final class RecommendationProperties
implements JsonSerializable<RecommendationProperties> {
    private OffsetDateTime creationTime;
    private UUID recommendationId;
    private String resourceId;
    private ResourceScopeType resourceScope;
    private String ruleName;
    private String displayName;
    private String message;
    private NotificationLevel level;
    private Channels channels;
    private List<String> categoryTags;
    private String actionName;
    private Integer enabled;
    private List<String> states;
    private OffsetDateTime startTime;
    private OffsetDateTime endTime;
    private OffsetDateTime nextNotificationTime;
    private OffsetDateTime notificationExpirationTime;
    private OffsetDateTime notifiedTime;
    private Double score;
    private Boolean isDynamic;
    private String extensionName;
    private String bladeName;
    private String forwardLink;

    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    public RecommendationProperties withCreationTime(OffsetDateTime creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    public UUID recommendationId() {
        return this.recommendationId;
    }

    public RecommendationProperties withRecommendationId(UUID recommendationId) {
        this.recommendationId = recommendationId;
        return this;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public RecommendationProperties withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public ResourceScopeType resourceScope() {
        return this.resourceScope;
    }

    public RecommendationProperties withResourceScope(ResourceScopeType resourceScope) {
        this.resourceScope = resourceScope;
        return this;
    }

    public String ruleName() {
        return this.ruleName;
    }

    public RecommendationProperties withRuleName(String ruleName) {
        this.ruleName = ruleName;
        return this;
    }

    public String displayName() {
        return this.displayName;
    }

    public RecommendationProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String message() {
        return this.message;
    }

    public RecommendationProperties withMessage(String message) {
        this.message = message;
        return this;
    }

    public NotificationLevel level() {
        return this.level;
    }

    public RecommendationProperties withLevel(NotificationLevel level) {
        this.level = level;
        return this;
    }

    public Channels channels() {
        return this.channels;
    }

    public RecommendationProperties withChannels(Channels channels) {
        this.channels = channels;
        return this;
    }

    public List<String> categoryTags() {
        return this.categoryTags;
    }

    public String actionName() {
        return this.actionName;
    }

    public RecommendationProperties withActionName(String actionName) {
        this.actionName = actionName;
        return this;
    }

    public Integer enabled() {
        return this.enabled;
    }

    public RecommendationProperties withEnabled(Integer enabled) {
        this.enabled = enabled;
        return this;
    }

    public List<String> states() {
        return this.states;
    }

    public RecommendationProperties withStates(List<String> states) {
        this.states = states;
        return this;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public RecommendationProperties withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    public RecommendationProperties withEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    public OffsetDateTime nextNotificationTime() {
        return this.nextNotificationTime;
    }

    public RecommendationProperties withNextNotificationTime(OffsetDateTime nextNotificationTime) {
        this.nextNotificationTime = nextNotificationTime;
        return this;
    }

    public OffsetDateTime notificationExpirationTime() {
        return this.notificationExpirationTime;
    }

    public RecommendationProperties withNotificationExpirationTime(OffsetDateTime notificationExpirationTime) {
        this.notificationExpirationTime = notificationExpirationTime;
        return this;
    }

    public OffsetDateTime notifiedTime() {
        return this.notifiedTime;
    }

    public RecommendationProperties withNotifiedTime(OffsetDateTime notifiedTime) {
        this.notifiedTime = notifiedTime;
        return this;
    }

    public Double score() {
        return this.score;
    }

    public RecommendationProperties withScore(Double score) {
        this.score = score;
        return this;
    }

    public Boolean isDynamic() {
        return this.isDynamic;
    }

    public RecommendationProperties withIsDynamic(Boolean isDynamic) {
        this.isDynamic = isDynamic;
        return this;
    }

    public String extensionName() {
        return this.extensionName;
    }

    public RecommendationProperties withExtensionName(String extensionName) {
        this.extensionName = extensionName;
        return this;
    }

    public String bladeName() {
        return this.bladeName;
    }

    public RecommendationProperties withBladeName(String bladeName) {
        this.bladeName = bladeName;
        return this;
    }

    public String forwardLink() {
        return this.forwardLink;
    }

    public RecommendationProperties withForwardLink(String forwardLink) {
        this.forwardLink = forwardLink;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("creationTime", this.creationTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.creationTime));
        jsonWriter.writeStringField("recommendationId", Objects.toString(this.recommendationId, null));
        jsonWriter.writeStringField("resourceId", this.resourceId);
        jsonWriter.writeStringField("resourceScope", this.resourceScope == null ? null : this.resourceScope.toString());
        jsonWriter.writeStringField("ruleName", this.ruleName);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeStringField("level", this.level == null ? null : this.level.toString());
        jsonWriter.writeStringField("channels", this.channels == null ? null : this.channels.toString());
        jsonWriter.writeStringField("actionName", this.actionName);
        jsonWriter.writeNumberField("enabled", (Number)this.enabled);
        jsonWriter.writeArrayField("states", this.states, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("startTime", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("endTime", this.endTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endTime));
        jsonWriter.writeStringField("nextNotificationTime", this.nextNotificationTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.nextNotificationTime));
        jsonWriter.writeStringField("notificationExpirationTime", this.notificationExpirationTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.notificationExpirationTime));
        jsonWriter.writeStringField("notifiedTime", this.notifiedTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.notifiedTime));
        jsonWriter.writeNumberField("score", (Number)this.score);
        jsonWriter.writeBooleanField("isDynamic", this.isDynamic);
        jsonWriter.writeStringField("extensionName", this.extensionName);
        jsonWriter.writeStringField("bladeName", this.bladeName);
        jsonWriter.writeStringField("forwardLink", this.forwardLink);
        return jsonWriter.writeEndObject();
    }

    public static RecommendationProperties fromJson(JsonReader jsonReader) throws IOException {
        return (RecommendationProperties)jsonReader.readObject(reader -> {
            RecommendationProperties deserializedRecommendationProperties = new RecommendationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("creationTime".equals(fieldName)) {
                    deserializedRecommendationProperties.creationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("recommendationId".equals(fieldName)) {
                    deserializedRecommendationProperties.recommendationId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("resourceId".equals(fieldName)) {
                    deserializedRecommendationProperties.resourceId = reader.getString();
                    continue;
                }
                if ("resourceScope".equals(fieldName)) {
                    deserializedRecommendationProperties.resourceScope = ResourceScopeType.fromString(reader.getString());
                    continue;
                }
                if ("ruleName".equals(fieldName)) {
                    deserializedRecommendationProperties.ruleName = reader.getString();
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedRecommendationProperties.displayName = reader.getString();
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedRecommendationProperties.message = reader.getString();
                    continue;
                }
                if ("level".equals(fieldName)) {
                    deserializedRecommendationProperties.level = NotificationLevel.fromString(reader.getString());
                    continue;
                }
                if ("channels".equals(fieldName)) {
                    deserializedRecommendationProperties.channels = Channels.fromString(reader.getString());
                    continue;
                }
                if ("categoryTags".equals(fieldName)) {
                    List categoryTags;
                    deserializedRecommendationProperties.categoryTags = categoryTags = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("actionName".equals(fieldName)) {
                    deserializedRecommendationProperties.actionName = reader.getString();
                    continue;
                }
                if ("enabled".equals(fieldName)) {
                    deserializedRecommendationProperties.enabled = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("states".equals(fieldName)) {
                    List states;
                    deserializedRecommendationProperties.states = states = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedRecommendationProperties.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedRecommendationProperties.endTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("nextNotificationTime".equals(fieldName)) {
                    deserializedRecommendationProperties.nextNotificationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("notificationExpirationTime".equals(fieldName)) {
                    deserializedRecommendationProperties.notificationExpirationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("notifiedTime".equals(fieldName)) {
                    deserializedRecommendationProperties.notifiedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("score".equals(fieldName)) {
                    deserializedRecommendationProperties.score = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("isDynamic".equals(fieldName)) {
                    deserializedRecommendationProperties.isDynamic = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("extensionName".equals(fieldName)) {
                    deserializedRecommendationProperties.extensionName = reader.getString();
                    continue;
                }
                if ("bladeName".equals(fieldName)) {
                    deserializedRecommendationProperties.bladeName = reader.getString();
                    continue;
                }
                if ("forwardLink".equals(fieldName)) {
                    deserializedRecommendationProperties.forwardLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRecommendationProperties;
        });
    }
}

