// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Web App stack runtimes.
 */
@Immutable
public final class WebAppRuntimes implements JsonSerializable<WebAppRuntimes> {
    /*
     * Linux-specific settings associated with the minor version.
     */
    private WebAppRuntimeSettings linuxRuntimeSettings;

    /*
     * Windows-specific settings associated with the minor version.
     */
    private WebAppRuntimeSettings windowsRuntimeSettings;

    /*
     * Linux-specific settings associated with the Java container minor version.
     */
    private LinuxJavaContainerSettings linuxContainerSettings;

    /*
     * Windows-specific settings associated with the Java container minor version.
     */
    private WindowsJavaContainerSettings windowsContainerSettings;

    /**
     * Creates an instance of WebAppRuntimes class.
     */
    public WebAppRuntimes() {
    }

    /**
     * Get the linuxRuntimeSettings property: Linux-specific settings associated with the minor version.
     * 
     * @return the linuxRuntimeSettings value.
     */
    public WebAppRuntimeSettings linuxRuntimeSettings() {
        return this.linuxRuntimeSettings;
    }

    /**
     * Get the windowsRuntimeSettings property: Windows-specific settings associated with the minor version.
     * 
     * @return the windowsRuntimeSettings value.
     */
    public WebAppRuntimeSettings windowsRuntimeSettings() {
        return this.windowsRuntimeSettings;
    }

    /**
     * Get the linuxContainerSettings property: Linux-specific settings associated with the Java container minor
     * version.
     * 
     * @return the linuxContainerSettings value.
     */
    public LinuxJavaContainerSettings linuxContainerSettings() {
        return this.linuxContainerSettings;
    }

    /**
     * Get the windowsContainerSettings property: Windows-specific settings associated with the Java container minor
     * version.
     * 
     * @return the windowsContainerSettings value.
     */
    public WindowsJavaContainerSettings windowsContainerSettings() {
        return this.windowsContainerSettings;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (linuxRuntimeSettings() != null) {
            linuxRuntimeSettings().validate();
        }
        if (windowsRuntimeSettings() != null) {
            windowsRuntimeSettings().validate();
        }
        if (linuxContainerSettings() != null) {
            linuxContainerSettings().validate();
        }
        if (windowsContainerSettings() != null) {
            windowsContainerSettings().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WebAppRuntimes from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WebAppRuntimes if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the WebAppRuntimes.
     */
    public static WebAppRuntimes fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WebAppRuntimes deserializedWebAppRuntimes = new WebAppRuntimes();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("linuxRuntimeSettings".equals(fieldName)) {
                    deserializedWebAppRuntimes.linuxRuntimeSettings = WebAppRuntimeSettings.fromJson(reader);
                } else if ("windowsRuntimeSettings".equals(fieldName)) {
                    deserializedWebAppRuntimes.windowsRuntimeSettings = WebAppRuntimeSettings.fromJson(reader);
                } else if ("linuxContainerSettings".equals(fieldName)) {
                    deserializedWebAppRuntimes.linuxContainerSettings = LinuxJavaContainerSettings.fromJson(reader);
                } else if ("windowsContainerSettings".equals(fieldName)) {
                    deserializedWebAppRuntimes.windowsContainerSettings = WindowsJavaContainerSettings.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedWebAppRuntimes;
        });
    }
}
