// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Container App versioned application definition.
 * Defines the desired state of an immutable revision.
 * Any changes to this section Will result in a new revision being created.
 */
@Fluent
public final class Template implements JsonSerializable<Template> {
    /*
     * User friendly suffix that is appended to the revision name
     */
    private String revisionSuffix;

    /*
     * List of container definitions for the Container App.
     */
    private List<Container> containers;

    /*
     * Scaling properties for the Container App.
     */
    private Scale scale;

    /*
     * Dapr configuration for the Container App.
     */
    private Dapr dapr;

    /**
     * Creates an instance of Template class.
     */
    public Template() {
    }

    /**
     * Get the revisionSuffix property: User friendly suffix that is appended to the revision name.
     * 
     * @return the revisionSuffix value.
     */
    public String revisionSuffix() {
        return this.revisionSuffix;
    }

    /**
     * Set the revisionSuffix property: User friendly suffix that is appended to the revision name.
     * 
     * @param revisionSuffix the revisionSuffix value to set.
     * @return the Template object itself.
     */
    public Template withRevisionSuffix(String revisionSuffix) {
        this.revisionSuffix = revisionSuffix;
        return this;
    }

    /**
     * Get the containers property: List of container definitions for the Container App.
     * 
     * @return the containers value.
     */
    public List<Container> containers() {
        return this.containers;
    }

    /**
     * Set the containers property: List of container definitions for the Container App.
     * 
     * @param containers the containers value to set.
     * @return the Template object itself.
     */
    public Template withContainers(List<Container> containers) {
        this.containers = containers;
        return this;
    }

    /**
     * Get the scale property: Scaling properties for the Container App.
     * 
     * @return the scale value.
     */
    public Scale scale() {
        return this.scale;
    }

    /**
     * Set the scale property: Scaling properties for the Container App.
     * 
     * @param scale the scale value to set.
     * @return the Template object itself.
     */
    public Template withScale(Scale scale) {
        this.scale = scale;
        return this;
    }

    /**
     * Get the dapr property: Dapr configuration for the Container App.
     * 
     * @return the dapr value.
     */
    public Dapr dapr() {
        return this.dapr;
    }

    /**
     * Set the dapr property: Dapr configuration for the Container App.
     * 
     * @param dapr the dapr value to set.
     * @return the Template object itself.
     */
    public Template withDapr(Dapr dapr) {
        this.dapr = dapr;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (containers() != null) {
            containers().forEach(e -> e.validate());
        }
        if (scale() != null) {
            scale().validate();
        }
        if (dapr() != null) {
            dapr().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("revisionSuffix", this.revisionSuffix);
        jsonWriter.writeArrayField("containers", this.containers, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("scale", this.scale);
        jsonWriter.writeJsonField("dapr", this.dapr);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Template from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Template if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the Template.
     */
    public static Template fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Template deserializedTemplate = new Template();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("revisionSuffix".equals(fieldName)) {
                    deserializedTemplate.revisionSuffix = reader.getString();
                } else if ("containers".equals(fieldName)) {
                    List<Container> containers = reader.readArray(reader1 -> Container.fromJson(reader1));
                    deserializedTemplate.containers = containers;
                } else if ("scale".equals(fieldName)) {
                    deserializedTemplate.scale = Scale.fromJson(reader);
                } else if ("dapr".equals(fieldName)) {
                    deserializedTemplate.dapr = Dapr.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTemplate;
        });
    }
}
