// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.RequestHistoryInner;
import java.io.IOException;
import java.util.List;

/**
 * The list of workflow request histories.
 */
@Fluent
public final class RequestHistoryListResult implements JsonSerializable<RequestHistoryListResult> {
    /*
     * A list of workflow request histories.
     */
    private List<RequestHistoryInner> value;

    /*
     * The URL to get the next set of results.
     */
    private String nextLink;

    /**
     * Creates an instance of RequestHistoryListResult class.
     */
    public RequestHistoryListResult() {
    }

    /**
     * Get the value property: A list of workflow request histories.
     * 
     * @return the value value.
     */
    public List<RequestHistoryInner> value() {
        return this.value;
    }

    /**
     * Set the value property: A list of workflow request histories.
     * 
     * @param value the value value to set.
     * @return the RequestHistoryListResult object itself.
     */
    public RequestHistoryListResult withValue(List<RequestHistoryInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to get the next set of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URL to get the next set of results.
     * 
     * @param nextLink the nextLink value to set.
     * @return the RequestHistoryListResult object itself.
     */
    public RequestHistoryListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RequestHistoryListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RequestHistoryListResult if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RequestHistoryListResult.
     */
    public static RequestHistoryListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RequestHistoryListResult deserializedRequestHistoryListResult = new RequestHistoryListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<RequestHistoryInner> value
                        = reader.readArray(reader1 -> RequestHistoryInner.fromJson(reader1));
                    deserializedRequestHistoryListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedRequestHistoryListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRequestHistoryListResult;
        });
    }
}
