// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A request.
 */
@Fluent
public final class Request implements JsonSerializable<Request> {
    /*
     * A list of all the headers attached to the request.
     */
    private Object headers;

    /*
     * The destination for the request.
     */
    private String uri;

    /*
     * The HTTP method used for the request.
     */
    private String method;

    /**
     * Creates an instance of Request class.
     */
    public Request() {
    }

    /**
     * Get the headers property: A list of all the headers attached to the request.
     * 
     * @return the headers value.
     */
    public Object headers() {
        return this.headers;
    }

    /**
     * Set the headers property: A list of all the headers attached to the request.
     * 
     * @param headers the headers value to set.
     * @return the Request object itself.
     */
    public Request withHeaders(Object headers) {
        this.headers = headers;
        return this;
    }

    /**
     * Get the uri property: The destination for the request.
     * 
     * @return the uri value.
     */
    public String uri() {
        return this.uri;
    }

    /**
     * Set the uri property: The destination for the request.
     * 
     * @param uri the uri value to set.
     * @return the Request object itself.
     */
    public Request withUri(String uri) {
        this.uri = uri;
        return this;
    }

    /**
     * Get the method property: The HTTP method used for the request.
     * 
     * @return the method value.
     */
    public String method() {
        return this.method;
    }

    /**
     * Set the method property: The HTTP method used for the request.
     * 
     * @param method the method value to set.
     * @return the Request object itself.
     */
    public Request withMethod(String method) {
        this.method = method;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("headers", this.headers);
        jsonWriter.writeStringField("uri", this.uri);
        jsonWriter.writeStringField("method", this.method);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Request from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Request if the JsonReader was pointing to an instance of it, or null if it was pointing to
     * JSON null.
     * @throws IOException If an error occurs while reading the Request.
     */
    public static Request fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Request deserializedRequest = new Request();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("headers".equals(fieldName)) {
                    deserializedRequest.headers = reader.readUntyped();
                } else if ("uri".equals(fieldName)) {
                    deserializedRequest.uri = reader.getString();
                } else if ("method".equals(fieldName)) {
                    deserializedRequest.method = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRequest;
        });
    }
}
