// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Azure proxy only resource. This resource is not tracked by Azure Resource Manager.
 */
@Fluent
public class ProxyOnlyResource extends ProxyResource {
    /*
     * Kind of resource.
     */
    private String kind;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of ProxyOnlyResource class.
     */
    public ProxyOnlyResource() {
    }

    /**
     * Get the kind property: Kind of resource.
     * 
     * @return the kind value.
     */
    public String kind() {
        return this.kind;
    }

    /**
     * Set the kind property: Kind of resource.
     * 
     * @param kind the kind value to set.
     * @return the ProxyOnlyResource object itself.
     */
    public ProxyOnlyResource withKind(String kind) {
        this.kind = kind;
        return this;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ProxyOnlyResource from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ProxyOnlyResource if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ProxyOnlyResource.
     */
    public static ProxyOnlyResource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ProxyOnlyResource deserializedProxyOnlyResource = new ProxyOnlyResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedProxyOnlyResource.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedProxyOnlyResource.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedProxyOnlyResource.type = reader.getString();
                } else if ("kind".equals(fieldName)) {
                    deserializedProxyOnlyResource.kind = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedProxyOnlyResource;
        });
    }
}
