// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.PrivateLinkConnectionApprovalRequest;
import java.io.IOException;

/**
 * Private Endpoint Connection Approval ARM resource.
 */
@Fluent
public final class PrivateLinkConnectionApprovalRequestResource extends ProxyOnlyResource {
    /*
     * Core resource properties
     */
    private PrivateLinkConnectionApprovalRequest innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of PrivateLinkConnectionApprovalRequestResource class.
     */
    public PrivateLinkConnectionApprovalRequestResource() {
    }

    /**
     * Get the innerProperties property: Core resource properties.
     * 
     * @return the innerProperties value.
     */
    private PrivateLinkConnectionApprovalRequest innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public PrivateLinkConnectionApprovalRequestResource withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the privateLinkServiceConnectionState property: The state of a private link connection.
     * 
     * @return the privateLinkServiceConnectionState value.
     */
    public PrivateLinkConnectionState privateLinkServiceConnectionState() {
        return this.innerProperties() == null ? null : this.innerProperties().privateLinkServiceConnectionState();
    }

    /**
     * Set the privateLinkServiceConnectionState property: The state of a private link connection.
     * 
     * @param privateLinkServiceConnectionState the privateLinkServiceConnectionState value to set.
     * @return the PrivateLinkConnectionApprovalRequestResource object itself.
     */
    public PrivateLinkConnectionApprovalRequestResource
        withPrivateLinkServiceConnectionState(PrivateLinkConnectionState privateLinkServiceConnectionState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PrivateLinkConnectionApprovalRequest();
        }
        this.innerProperties().withPrivateLinkServiceConnectionState(privateLinkServiceConnectionState);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", kind());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PrivateLinkConnectionApprovalRequestResource from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PrivateLinkConnectionApprovalRequestResource if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the PrivateLinkConnectionApprovalRequestResource.
     */
    public static PrivateLinkConnectionApprovalRequestResource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PrivateLinkConnectionApprovalRequestResource deserializedPrivateLinkConnectionApprovalRequestResource
                = new PrivateLinkConnectionApprovalRequestResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedPrivateLinkConnectionApprovalRequestResource.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedPrivateLinkConnectionApprovalRequestResource.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedPrivateLinkConnectionApprovalRequestResource.type = reader.getString();
                } else if ("kind".equals(fieldName)) {
                    deserializedPrivateLinkConnectionApprovalRequestResource.withKind(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedPrivateLinkConnectionApprovalRequestResource.innerProperties
                        = PrivateLinkConnectionApprovalRequest.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPrivateLinkConnectionApprovalRequestResource;
        });
    }
}
