// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

/**
 * Metric information.
 */
@Fluent
public final class PerfMonSet implements JsonSerializable<PerfMonSet> {
    /*
     * Unique key name of the counter.
     */
    private String name;

    /*
     * Start time of the period.
     */
    private OffsetDateTime startTime;

    /*
     * End time of the period.
     */
    private OffsetDateTime endTime;

    /*
     * Presented time grain.
     */
    private String timeGrain;

    /*
     * Collection of workers that are active during this time.
     */
    private List<PerfMonSample> values;

    /**
     * Creates an instance of PerfMonSet class.
     */
    public PerfMonSet() {
    }

    /**
     * Get the name property: Unique key name of the counter.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Unique key name of the counter.
     * 
     * @param name the name value to set.
     * @return the PerfMonSet object itself.
     */
    public PerfMonSet withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the startTime property: Start time of the period.
     * 
     * @return the startTime value.
     */
    public OffsetDateTime startTime() {
        return this.startTime;
    }

    /**
     * Set the startTime property: Start time of the period.
     * 
     * @param startTime the startTime value to set.
     * @return the PerfMonSet object itself.
     */
    public PerfMonSet withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    /**
     * Get the endTime property: End time of the period.
     * 
     * @return the endTime value.
     */
    public OffsetDateTime endTime() {
        return this.endTime;
    }

    /**
     * Set the endTime property: End time of the period.
     * 
     * @param endTime the endTime value to set.
     * @return the PerfMonSet object itself.
     */
    public PerfMonSet withEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    /**
     * Get the timeGrain property: Presented time grain.
     * 
     * @return the timeGrain value.
     */
    public String timeGrain() {
        return this.timeGrain;
    }

    /**
     * Set the timeGrain property: Presented time grain.
     * 
     * @param timeGrain the timeGrain value to set.
     * @return the PerfMonSet object itself.
     */
    public PerfMonSet withTimeGrain(String timeGrain) {
        this.timeGrain = timeGrain;
        return this;
    }

    /**
     * Get the values property: Collection of workers that are active during this time.
     * 
     * @return the values value.
     */
    public List<PerfMonSample> values() {
        return this.values;
    }

    /**
     * Set the values property: Collection of workers that are active during this time.
     * 
     * @param values the values value to set.
     * @return the PerfMonSet object itself.
     */
    public PerfMonSet withValues(List<PerfMonSample> values) {
        this.values = values;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (values() != null) {
            values().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("startTime",
            this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("endTime",
            this.endTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endTime));
        jsonWriter.writeStringField("timeGrain", this.timeGrain);
        jsonWriter.writeArrayField("values", this.values, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PerfMonSet from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PerfMonSet if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the PerfMonSet.
     */
    public static PerfMonSet fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PerfMonSet deserializedPerfMonSet = new PerfMonSet();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedPerfMonSet.name = reader.getString();
                } else if ("startTime".equals(fieldName)) {
                    deserializedPerfMonSet.startTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("endTime".equals(fieldName)) {
                    deserializedPerfMonSet.endTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("timeGrain".equals(fieldName)) {
                    deserializedPerfMonSet.timeGrain = reader.getString();
                } else if ("values".equals(fieldName)) {
                    List<PerfMonSample> values = reader.readArray(reader1 -> PerfMonSample.fromJson(reader1));
                    deserializedPerfMonSet.values = values;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPerfMonSet;
        });
    }
}
