// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The configuration settings of the legacy Microsoft Account provider.
 */
@Fluent
public final class LegacyMicrosoftAccount implements JsonSerializable<LegacyMicrosoftAccount> {
    /*
     * <code>false</code> if the legacy Microsoft Account provider should not be enabled despite the set registration;
     * otherwise, <code>true</code>.
     */
    private Boolean enabled;

    /*
     * The configuration settings of the app registration for the legacy Microsoft Account provider.
     */
    private ClientRegistration registration;

    /*
     * The configuration settings of the login flow.
     */
    private LoginScopes login;

    /*
     * The configuration settings of the legacy Microsoft Account provider token validation flow.
     */
    private AllowedAudiencesValidation validation;

    /**
     * Creates an instance of LegacyMicrosoftAccount class.
     */
    public LegacyMicrosoftAccount() {
    }

    /**
     * Get the enabled property: &lt;code&gt;false&lt;/code&gt; if the legacy Microsoft Account provider should not be
     * enabled despite the set registration; otherwise, &lt;code&gt;true&lt;/code&gt;.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: &lt;code&gt;false&lt;/code&gt; if the legacy Microsoft Account provider should not be
     * enabled despite the set registration; otherwise, &lt;code&gt;true&lt;/code&gt;.
     * 
     * @param enabled the enabled value to set.
     * @return the LegacyMicrosoftAccount object itself.
     */
    public LegacyMicrosoftAccount withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Get the registration property: The configuration settings of the app registration for the legacy Microsoft
     * Account provider.
     * 
     * @return the registration value.
     */
    public ClientRegistration registration() {
        return this.registration;
    }

    /**
     * Set the registration property: The configuration settings of the app registration for the legacy Microsoft
     * Account provider.
     * 
     * @param registration the registration value to set.
     * @return the LegacyMicrosoftAccount object itself.
     */
    public LegacyMicrosoftAccount withRegistration(ClientRegistration registration) {
        this.registration = registration;
        return this;
    }

    /**
     * Get the login property: The configuration settings of the login flow.
     * 
     * @return the login value.
     */
    public LoginScopes login() {
        return this.login;
    }

    /**
     * Set the login property: The configuration settings of the login flow.
     * 
     * @param login the login value to set.
     * @return the LegacyMicrosoftAccount object itself.
     */
    public LegacyMicrosoftAccount withLogin(LoginScopes login) {
        this.login = login;
        return this;
    }

    /**
     * Get the validation property: The configuration settings of the legacy Microsoft Account provider token validation
     * flow.
     * 
     * @return the validation value.
     */
    public AllowedAudiencesValidation validation() {
        return this.validation;
    }

    /**
     * Set the validation property: The configuration settings of the legacy Microsoft Account provider token validation
     * flow.
     * 
     * @param validation the validation value to set.
     * @return the LegacyMicrosoftAccount object itself.
     */
    public LegacyMicrosoftAccount withValidation(AllowedAudiencesValidation validation) {
        this.validation = validation;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (registration() != null) {
            registration().validate();
        }
        if (login() != null) {
            login().validate();
        }
        if (validation() != null) {
            validation().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeJsonField("registration", this.registration);
        jsonWriter.writeJsonField("login", this.login);
        jsonWriter.writeJsonField("validation", this.validation);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LegacyMicrosoftAccount from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LegacyMicrosoftAccount if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the LegacyMicrosoftAccount.
     */
    public static LegacyMicrosoftAccount fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LegacyMicrosoftAccount deserializedLegacyMicrosoftAccount = new LegacyMicrosoftAccount();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("enabled".equals(fieldName)) {
                    deserializedLegacyMicrosoftAccount.enabled = reader.getNullable(JsonReader::getBoolean);
                } else if ("registration".equals(fieldName)) {
                    deserializedLegacyMicrosoftAccount.registration = ClientRegistration.fromJson(reader);
                } else if ("login".equals(fieldName)) {
                    deserializedLegacyMicrosoftAccount.login = LoginScopes.fromJson(reader);
                } else if ("validation".equals(fieldName)) {
                    deserializedLegacyMicrosoftAccount.validation = AllowedAudiencesValidation.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLegacyMicrosoftAccount;
        });
    }
}
