// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Function App stack runtimes.
 */
@Immutable
public final class FunctionAppRuntimes implements JsonSerializable<FunctionAppRuntimes> {
    /*
     * Linux-specific settings associated with the minor version.
     */
    private FunctionAppRuntimeSettings linuxRuntimeSettings;

    /*
     * Windows-specific settings associated with the minor version.
     */
    private FunctionAppRuntimeSettings windowsRuntimeSettings;

    /**
     * Creates an instance of FunctionAppRuntimes class.
     */
    public FunctionAppRuntimes() {
    }

    /**
     * Get the linuxRuntimeSettings property: Linux-specific settings associated with the minor version.
     * 
     * @return the linuxRuntimeSettings value.
     */
    public FunctionAppRuntimeSettings linuxRuntimeSettings() {
        return this.linuxRuntimeSettings;
    }

    /**
     * Get the windowsRuntimeSettings property: Windows-specific settings associated with the minor version.
     * 
     * @return the windowsRuntimeSettings value.
     */
    public FunctionAppRuntimeSettings windowsRuntimeSettings() {
        return this.windowsRuntimeSettings;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (linuxRuntimeSettings() != null) {
            linuxRuntimeSettings().validate();
        }
        if (windowsRuntimeSettings() != null) {
            windowsRuntimeSettings().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FunctionAppRuntimes from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FunctionAppRuntimes if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the FunctionAppRuntimes.
     */
    public static FunctionAppRuntimes fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FunctionAppRuntimes deserializedFunctionAppRuntimes = new FunctionAppRuntimes();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("linuxRuntimeSettings".equals(fieldName)) {
                    deserializedFunctionAppRuntimes.linuxRuntimeSettings = FunctionAppRuntimeSettings.fromJson(reader);
                } else if ("windowsRuntimeSettings".equals(fieldName)) {
                    deserializedFunctionAppRuntimes.windowsRuntimeSettings
                        = FunctionAppRuntimeSettings.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFunctionAppRuntimes;
        });
    }
}
