// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

/**
 * Function App runtime settings.
 */
@Immutable
public final class FunctionAppRuntimeSettings implements JsonSerializable<FunctionAppRuntimeSettings> {
    /*
     * Function App stack minor version (runtime only).
     */
    private String runtimeVersion;

    /*
     * <code>true</code> if remote debugging is supported for the stack; otherwise, <code>false</code>.
     */
    private Boolean remoteDebuggingSupported;

    /*
     * Application Insights settings associated with the minor version.
     */
    private AppInsightsWebAppStackSettings appInsightsSettings;

    /*
     * GitHub Actions settings associated with the minor version.
     */
    private GitHubActionWebAppStackSettings gitHubActionSettings;

    /*
     * Application settings associated with the minor version.
     */
    private Map<String, String> appSettingsDictionary;

    /*
     * Configuration settings associated with the minor version.
     */
    private SiteConfigPropertiesDictionary siteConfigPropertiesDictionary;

    /*
     * List of supported Functions extension versions.
     */
    private List<String> supportedFunctionsExtensionVersions;

    /*
     * <code>true</code> if the stack is in preview; otherwise, <code>false</code>.
     */
    private Boolean isPreview;

    /*
     * <code>true</code> if the stack is deprecated; otherwise, <code>false</code>.
     */
    private Boolean isDeprecated;

    /*
     * <code>true</code> if the stack should be hidden; otherwise, <code>false</code>.
     */
    private Boolean isHidden;

    /*
     * End-of-life date for the minor version.
     */
    private OffsetDateTime endOfLifeDate;

    /*
     * <code>true</code> if the stack version is auto-updated; otherwise, <code>false</code>.
     */
    private Boolean isAutoUpdate;

    /*
     * <code>true</code> if the minor version is early-access; otherwise, <code>false</code>.
     */
    private Boolean isEarlyAccess;

    /*
     * <code>true</code> if the minor version the default; otherwise, <code>false</code>.
     */
    private Boolean isDefault;

    /**
     * Creates an instance of FunctionAppRuntimeSettings class.
     */
    public FunctionAppRuntimeSettings() {
    }

    /**
     * Get the runtimeVersion property: Function App stack minor version (runtime only).
     * 
     * @return the runtimeVersion value.
     */
    public String runtimeVersion() {
        return this.runtimeVersion;
    }

    /**
     * Get the remoteDebuggingSupported property: &lt;code&gt;true&lt;/code&gt; if remote debugging is supported for the
     * stack; otherwise, &lt;code&gt;false&lt;/code&gt;.
     * 
     * @return the remoteDebuggingSupported value.
     */
    public Boolean remoteDebuggingSupported() {
        return this.remoteDebuggingSupported;
    }

    /**
     * Get the appInsightsSettings property: Application Insights settings associated with the minor version.
     * 
     * @return the appInsightsSettings value.
     */
    public AppInsightsWebAppStackSettings appInsightsSettings() {
        return this.appInsightsSettings;
    }

    /**
     * Get the gitHubActionSettings property: GitHub Actions settings associated with the minor version.
     * 
     * @return the gitHubActionSettings value.
     */
    public GitHubActionWebAppStackSettings gitHubActionSettings() {
        return this.gitHubActionSettings;
    }

    /**
     * Get the appSettingsDictionary property: Application settings associated with the minor version.
     * 
     * @return the appSettingsDictionary value.
     */
    public Map<String, String> appSettingsDictionary() {
        return this.appSettingsDictionary;
    }

    /**
     * Get the siteConfigPropertiesDictionary property: Configuration settings associated with the minor version.
     * 
     * @return the siteConfigPropertiesDictionary value.
     */
    public SiteConfigPropertiesDictionary siteConfigPropertiesDictionary() {
        return this.siteConfigPropertiesDictionary;
    }

    /**
     * Get the supportedFunctionsExtensionVersions property: List of supported Functions extension versions.
     * 
     * @return the supportedFunctionsExtensionVersions value.
     */
    public List<String> supportedFunctionsExtensionVersions() {
        return this.supportedFunctionsExtensionVersions;
    }

    /**
     * Get the isPreview property: &lt;code&gt;true&lt;/code&gt; if the stack is in preview; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     * 
     * @return the isPreview value.
     */
    public Boolean isPreview() {
        return this.isPreview;
    }

    /**
     * Get the isDeprecated property: &lt;code&gt;true&lt;/code&gt; if the stack is deprecated; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     * 
     * @return the isDeprecated value.
     */
    public Boolean isDeprecated() {
        return this.isDeprecated;
    }

    /**
     * Get the isHidden property: &lt;code&gt;true&lt;/code&gt; if the stack should be hidden; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     * 
     * @return the isHidden value.
     */
    public Boolean isHidden() {
        return this.isHidden;
    }

    /**
     * Get the endOfLifeDate property: End-of-life date for the minor version.
     * 
     * @return the endOfLifeDate value.
     */
    public OffsetDateTime endOfLifeDate() {
        return this.endOfLifeDate;
    }

    /**
     * Get the isAutoUpdate property: &lt;code&gt;true&lt;/code&gt; if the stack version is auto-updated; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     * 
     * @return the isAutoUpdate value.
     */
    public Boolean isAutoUpdate() {
        return this.isAutoUpdate;
    }

    /**
     * Get the isEarlyAccess property: &lt;code&gt;true&lt;/code&gt; if the minor version is early-access; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     * 
     * @return the isEarlyAccess value.
     */
    public Boolean isEarlyAccess() {
        return this.isEarlyAccess;
    }

    /**
     * Get the isDefault property: &lt;code&gt;true&lt;/code&gt; if the minor version the default; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     * 
     * @return the isDefault value.
     */
    public Boolean isDefault() {
        return this.isDefault;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (appInsightsSettings() != null) {
            appInsightsSettings().validate();
        }
        if (gitHubActionSettings() != null) {
            gitHubActionSettings().validate();
        }
        if (siteConfigPropertiesDictionary() != null) {
            siteConfigPropertiesDictionary().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FunctionAppRuntimeSettings from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FunctionAppRuntimeSettings if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the FunctionAppRuntimeSettings.
     */
    public static FunctionAppRuntimeSettings fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FunctionAppRuntimeSettings deserializedFunctionAppRuntimeSettings = new FunctionAppRuntimeSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("runtimeVersion".equals(fieldName)) {
                    deserializedFunctionAppRuntimeSettings.runtimeVersion = reader.getString();
                } else if ("remoteDebuggingSupported".equals(fieldName)) {
                    deserializedFunctionAppRuntimeSettings.remoteDebuggingSupported
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("appInsightsSettings".equals(fieldName)) {
                    deserializedFunctionAppRuntimeSettings.appInsightsSettings
                        = AppInsightsWebAppStackSettings.fromJson(reader);
                } else if ("gitHubActionSettings".equals(fieldName)) {
                    deserializedFunctionAppRuntimeSettings.gitHubActionSettings
                        = GitHubActionWebAppStackSettings.fromJson(reader);
                } else if ("appSettingsDictionary".equals(fieldName)) {
                    Map<String, String> appSettingsDictionary = reader.readMap(reader1 -> reader1.getString());
                    deserializedFunctionAppRuntimeSettings.appSettingsDictionary = appSettingsDictionary;
                } else if ("siteConfigPropertiesDictionary".equals(fieldName)) {
                    deserializedFunctionAppRuntimeSettings.siteConfigPropertiesDictionary
                        = SiteConfigPropertiesDictionary.fromJson(reader);
                } else if ("supportedFunctionsExtensionVersions".equals(fieldName)) {
                    List<String> supportedFunctionsExtensionVersions = reader.readArray(reader1 -> reader1.getString());
                    deserializedFunctionAppRuntimeSettings.supportedFunctionsExtensionVersions
                        = supportedFunctionsExtensionVersions;
                } else if ("isPreview".equals(fieldName)) {
                    deserializedFunctionAppRuntimeSettings.isPreview = reader.getNullable(JsonReader::getBoolean);
                } else if ("isDeprecated".equals(fieldName)) {
                    deserializedFunctionAppRuntimeSettings.isDeprecated = reader.getNullable(JsonReader::getBoolean);
                } else if ("isHidden".equals(fieldName)) {
                    deserializedFunctionAppRuntimeSettings.isHidden = reader.getNullable(JsonReader::getBoolean);
                } else if ("endOfLifeDate".equals(fieldName)) {
                    deserializedFunctionAppRuntimeSettings.endOfLifeDate = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("isAutoUpdate".equals(fieldName)) {
                    deserializedFunctionAppRuntimeSettings.isAutoUpdate = reader.getNullable(JsonReader::getBoolean);
                } else if ("isEarlyAccess".equals(fieldName)) {
                    deserializedFunctionAppRuntimeSettings.isEarlyAccess = reader.getNullable(JsonReader::getBoolean);
                } else if ("isDefault".equals(fieldName)) {
                    deserializedFunctionAppRuntimeSettings.isDefault = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFunctionAppRuntimeSettings;
        });
    }
}
