// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Static Site Database Connection overview.
 */
@Immutable
public final class DatabaseConnectionOverview implements JsonSerializable<DatabaseConnectionOverview> {
    /*
     * The resource id of the database.
     */
    private String resourceId;

    /*
     * If present, the identity is used in conjunction with connection string to connect to the database. Use of the
     * system-assigned managed identity is indicated with the string 'SystemAssigned', while use of a user-assigned
     * managed identity is indicated with the resource id of the managed identity resource.
     */
    private String connectionIdentity;

    /*
     * The region of the database resource.
     */
    private String region;

    /*
     * A list of configuration files associated with this database connection.
     */
    private List<StaticSiteDatabaseConnectionConfigurationFileOverview> configurationFiles;

    /*
     * If present, the name of this database connection resource.
     */
    private String name;

    /**
     * Creates an instance of DatabaseConnectionOverview class.
     */
    public DatabaseConnectionOverview() {
    }

    /**
     * Get the resourceId property: The resource id of the database.
     * 
     * @return the resourceId value.
     */
    public String resourceId() {
        return this.resourceId;
    }

    /**
     * Get the connectionIdentity property: If present, the identity is used in conjunction with connection string to
     * connect to the database. Use of the system-assigned managed identity is indicated with the string
     * 'SystemAssigned', while use of a user-assigned managed identity is indicated with the resource id of the managed
     * identity resource.
     * 
     * @return the connectionIdentity value.
     */
    public String connectionIdentity() {
        return this.connectionIdentity;
    }

    /**
     * Get the region property: The region of the database resource.
     * 
     * @return the region value.
     */
    public String region() {
        return this.region;
    }

    /**
     * Get the configurationFiles property: A list of configuration files associated with this database connection.
     * 
     * @return the configurationFiles value.
     */
    public List<StaticSiteDatabaseConnectionConfigurationFileOverview> configurationFiles() {
        return this.configurationFiles;
    }

    /**
     * Get the name property: If present, the name of this database connection resource.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (configurationFiles() != null) {
            configurationFiles().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DatabaseConnectionOverview from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DatabaseConnectionOverview if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DatabaseConnectionOverview.
     */
    public static DatabaseConnectionOverview fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DatabaseConnectionOverview deserializedDatabaseConnectionOverview = new DatabaseConnectionOverview();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("resourceId".equals(fieldName)) {
                    deserializedDatabaseConnectionOverview.resourceId = reader.getString();
                } else if ("connectionIdentity".equals(fieldName)) {
                    deserializedDatabaseConnectionOverview.connectionIdentity = reader.getString();
                } else if ("region".equals(fieldName)) {
                    deserializedDatabaseConnectionOverview.region = reader.getString();
                } else if ("configurationFiles".equals(fieldName)) {
                    List<StaticSiteDatabaseConnectionConfigurationFileOverview> configurationFiles = reader
                        .readArray(reader1 -> StaticSiteDatabaseConnectionConfigurationFileOverview.fromJson(reader1));
                    deserializedDatabaseConnectionOverview.configurationFiles = configurationFiles;
                } else if ("name".equals(fieldName)) {
                    deserializedDatabaseConnectionOverview.name = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDatabaseConnectionOverview;
        });
    }
}
