// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Azure API management (APIM) configuration linked to the app.
 */
@Fluent
public final class ApiManagementConfig implements JsonSerializable<ApiManagementConfig> {
    /*
     * APIM-Api Identifier.
     */
    private String id;

    /**
     * Creates an instance of ApiManagementConfig class.
     */
    public ApiManagementConfig() {
    }

    /**
     * Get the id property: APIM-Api Identifier.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: APIM-Api Identifier.
     * 
     * @param id the id value to set.
     * @return the ApiManagementConfig object itself.
     */
    public ApiManagementConfig withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApiManagementConfig from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApiManagementConfig if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApiManagementConfig.
     */
    public static ApiManagementConfig fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApiManagementConfig deserializedApiManagementConfig = new ApiManagementConfig();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedApiManagementConfig.id = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApiManagementConfig;
        });
    }
}
