// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.resourcemanager.appservice.fluent.RecommendationsClient;
import com.azure.resourcemanager.appservice.fluent.models.RecommendationInner;
import com.azure.resourcemanager.appservice.fluent.models.RecommendationRuleInner;
import com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException;
import com.azure.resourcemanager.appservice.models.RecommendationCollection;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in RecommendationsClient.
 */
public final class RecommendationsClientImpl implements RecommendationsClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final RecommendationsService service;

    /**
     * The service client containing this operation class.
     */
    private final WebSiteManagementClientImpl client;

    /**
     * Initializes an instance of RecommendationsClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    RecommendationsClientImpl(WebSiteManagementClientImpl client) {
        this.service
            = RestProxy.create(RecommendationsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for WebSiteManagementClientRecommendations to be used by the proxy
     * service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "WebSiteManagementCli")
    public interface RecommendationsService {
        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/providers/Microsoft.Web/recommendations")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<RecommendationCollection>> list(@HostParam("$host") String endpoint,
            @QueryParam("featured") Boolean featured, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @QueryParam(value = "$filter", encoded = true) String filter,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/providers/Microsoft.Web/recommendations/reset")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> resetAllFilters(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/providers/Microsoft.Web/recommendations/{name}/disable")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> disableRecommendationForSubscription(@HostParam("$host") String endpoint,
            @PathParam("name") String name, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{hostingEnvironmentName}/recommendationHistory")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<RecommendationCollection>> listHistoryForHostingEnvironment(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("hostingEnvironmentName") String hostingEnvironmentName,
            @QueryParam("expiredOnly") Boolean expiredOnly, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @QueryParam(value = "$filter", encoded = true) String filter,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{hostingEnvironmentName}/recommendations")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<RecommendationCollection>> listRecommendedRulesForHostingEnvironment(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("hostingEnvironmentName") String hostingEnvironmentName,
            @QueryParam("featured") Boolean featured, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @QueryParam(value = "$filter", encoded = true) String filter,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{hostingEnvironmentName}/recommendations/disable")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> disableAllForHostingEnvironment(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @QueryParam("environmentName") String environmentName,
            @PathParam("hostingEnvironmentName") String hostingEnvironmentName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{hostingEnvironmentName}/recommendations/reset")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> resetAllFiltersForHostingEnvironment(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @QueryParam("environmentName") String environmentName,
            @PathParam("hostingEnvironmentName") String hostingEnvironmentName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{hostingEnvironmentName}/recommendations/{name}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<RecommendationRuleInner>> getRuleDetailsByHostingEnvironment(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("hostingEnvironmentName") String hostingEnvironmentName, @PathParam("name") String name,
            @QueryParam("updateSeen") Boolean updateSeen, @QueryParam("recommendationId") String recommendationId,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{hostingEnvironmentName}/recommendations/{name}/disable")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> disableRecommendationForHostingEnvironment(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @QueryParam("environmentName") String environmentName, @PathParam("name") String name,
            @PathParam("hostingEnvironmentName") String hostingEnvironmentName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/recommendationHistory")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<RecommendationCollection>> listHistoryForWebApp(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("siteName") String siteName,
            @QueryParam("expiredOnly") Boolean expiredOnly, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @QueryParam(value = "$filter", encoded = true) String filter,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/recommendations")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<RecommendationCollection>> listRecommendedRulesForWebApp(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("siteName") String siteName,
            @QueryParam("featured") Boolean featured, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @QueryParam(value = "$filter", encoded = true) String filter,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/recommendations/disable")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> disableAllForWebApp(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("siteName") String siteName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/recommendations/reset")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> resetAllFiltersForWebApp(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("siteName") String siteName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/recommendations/{name}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<RecommendationRuleInner>> getRuleDetailsByWebApp(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("siteName") String siteName,
            @PathParam("name") String name, @QueryParam("updateSeen") Boolean updateSeen,
            @QueryParam("recommendationId") String recommendationId, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/recommendations/{name}/disable")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<Void>> disableRecommendationForSite(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("siteName") String siteName,
            @PathParam("name") String name, @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<RecommendationCollection>> listNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<RecommendationCollection>> listHistoryForHostingEnvironmentNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<RecommendationCollection>> listRecommendedRulesForHostingEnvironmentNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<RecommendationCollection>> listHistoryForWebAppNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(DefaultErrorResponseErrorException.class)
        Mono<Response<RecommendationCollection>> listRecommendedRulesForWebAppNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * List all recommendations for a subscription.
     * 
     * Description for List all recommendations for a subscription.
     * 
     * @param featured Specify &lt;code&gt;true&lt;/code&gt; to return only the most critical recommendations. The
     * default is &lt;code&gt;false&lt;/code&gt;, which returns all recommendations.
     * @param filter Filter is specified by using OData syntax. Example: $filter=channel eq 'Api' or channel eq
     * 'Notification' and startTime eq 2014-01-01T00:00:00Z and endTime eq 2014-12-31T23:59:59Z and timeGrain eq
     * duration'[PT1H|PT1M|P1D].
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of recommendations along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RecommendationInner>> listSinglePageAsync(Boolean featured, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.list(this.client.getEndpoint(), featured, this.client.getSubscriptionId(),
                this.client.getApiVersion(), filter, accept, context))
            .<PagedResponse<RecommendationInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * List all recommendations for a subscription.
     * 
     * Description for List all recommendations for a subscription.
     * 
     * @param featured Specify &lt;code&gt;true&lt;/code&gt; to return only the most critical recommendations. The
     * default is &lt;code&gt;false&lt;/code&gt;, which returns all recommendations.
     * @param filter Filter is specified by using OData syntax. Example: $filter=channel eq 'Api' or channel eq
     * 'Notification' and startTime eq 2014-01-01T00:00:00Z and endTime eq 2014-12-31T23:59:59Z and timeGrain eq
     * duration'[PT1H|PT1M|P1D].
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of recommendations along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RecommendationInner>> listSinglePageAsync(Boolean featured, String filter,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .list(this.client.getEndpoint(), featured, this.client.getSubscriptionId(), this.client.getApiVersion(),
                filter, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * List all recommendations for a subscription.
     * 
     * Description for List all recommendations for a subscription.
     * 
     * @param featured Specify &lt;code&gt;true&lt;/code&gt; to return only the most critical recommendations. The
     * default is &lt;code&gt;false&lt;/code&gt;, which returns all recommendations.
     * @param filter Filter is specified by using OData syntax. Example: $filter=channel eq 'Api' or channel eq
     * 'Notification' and startTime eq 2014-01-01T00:00:00Z and endTime eq 2014-12-31T23:59:59Z and timeGrain eq
     * duration'[PT1H|PT1M|P1D].
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of recommendations as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<RecommendationInner> listAsync(Boolean featured, String filter) {
        return new PagedFlux<>(() -> listSinglePageAsync(featured, filter),
            nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * List all recommendations for a subscription.
     * 
     * Description for List all recommendations for a subscription.
     * 
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of recommendations as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<RecommendationInner> listAsync() {
        final Boolean featured = null;
        final String filter = null;
        return new PagedFlux<>(() -> listSinglePageAsync(featured, filter),
            nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * List all recommendations for a subscription.
     * 
     * Description for List all recommendations for a subscription.
     * 
     * @param featured Specify &lt;code&gt;true&lt;/code&gt; to return only the most critical recommendations. The
     * default is &lt;code&gt;false&lt;/code&gt;, which returns all recommendations.
     * @param filter Filter is specified by using OData syntax. Example: $filter=channel eq 'Api' or channel eq
     * 'Notification' and startTime eq 2014-01-01T00:00:00Z and endTime eq 2014-12-31T23:59:59Z and timeGrain eq
     * duration'[PT1H|PT1M|P1D].
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of recommendations as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<RecommendationInner> listAsync(Boolean featured, String filter, Context context) {
        return new PagedFlux<>(() -> listSinglePageAsync(featured, filter, context),
            nextLink -> listNextSinglePageAsync(nextLink, context));
    }

    /**
     * List all recommendations for a subscription.
     * 
     * Description for List all recommendations for a subscription.
     * 
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of recommendations as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<RecommendationInner> list() {
        final Boolean featured = null;
        final String filter = null;
        return new PagedIterable<>(listAsync(featured, filter));
    }

    /**
     * List all recommendations for a subscription.
     * 
     * Description for List all recommendations for a subscription.
     * 
     * @param featured Specify &lt;code&gt;true&lt;/code&gt; to return only the most critical recommendations. The
     * default is &lt;code&gt;false&lt;/code&gt;, which returns all recommendations.
     * @param filter Filter is specified by using OData syntax. Example: $filter=channel eq 'Api' or channel eq
     * 'Notification' and startTime eq 2014-01-01T00:00:00Z and endTime eq 2014-12-31T23:59:59Z and timeGrain eq
     * duration'[PT1H|PT1M|P1D].
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of recommendations as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<RecommendationInner> list(Boolean featured, String filter, Context context) {
        return new PagedIterable<>(listAsync(featured, filter, context));
    }

    /**
     * Reset all recommendation opt-out settings for a subscription.
     * 
     * Description for Reset all recommendation opt-out settings for a subscription.
     * 
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> resetAllFiltersWithResponseAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.resetAllFilters(this.client.getEndpoint(), this.client.getSubscriptionId(),
                this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Reset all recommendation opt-out settings for a subscription.
     * 
     * Description for Reset all recommendation opt-out settings for a subscription.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> resetAllFiltersWithResponseAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.resetAllFilters(this.client.getEndpoint(), this.client.getSubscriptionId(),
            this.client.getApiVersion(), accept, context);
    }

    /**
     * Reset all recommendation opt-out settings for a subscription.
     * 
     * Description for Reset all recommendation opt-out settings for a subscription.
     * 
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> resetAllFiltersAsync() {
        return resetAllFiltersWithResponseAsync().flatMap(ignored -> Mono.empty());
    }

    /**
     * Reset all recommendation opt-out settings for a subscription.
     * 
     * Description for Reset all recommendation opt-out settings for a subscription.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> resetAllFiltersWithResponse(Context context) {
        return resetAllFiltersWithResponseAsync(context).block();
    }

    /**
     * Reset all recommendation opt-out settings for a subscription.
     * 
     * Description for Reset all recommendation opt-out settings for a subscription.
     * 
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void resetAllFilters() {
        resetAllFiltersWithResponse(Context.NONE);
    }

    /**
     * Disables the specified rule so it will not apply to a subscription in the future.
     * 
     * Description for Disables the specified rule so it will not apply to a subscription in the future.
     * 
     * @param name Rule name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> disableRecommendationForSubscriptionWithResponseAsync(String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.disableRecommendationForSubscription(this.client.getEndpoint(), name,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Disables the specified rule so it will not apply to a subscription in the future.
     * 
     * Description for Disables the specified rule so it will not apply to a subscription in the future.
     * 
     * @param name Rule name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> disableRecommendationForSubscriptionWithResponseAsync(String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.disableRecommendationForSubscription(this.client.getEndpoint(), name,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Disables the specified rule so it will not apply to a subscription in the future.
     * 
     * Description for Disables the specified rule so it will not apply to a subscription in the future.
     * 
     * @param name Rule name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> disableRecommendationForSubscriptionAsync(String name) {
        return disableRecommendationForSubscriptionWithResponseAsync(name).flatMap(ignored -> Mono.empty());
    }

    /**
     * Disables the specified rule so it will not apply to a subscription in the future.
     * 
     * Description for Disables the specified rule so it will not apply to a subscription in the future.
     * 
     * @param name Rule name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> disableRecommendationForSubscriptionWithResponse(String name, Context context) {
        return disableRecommendationForSubscriptionWithResponseAsync(name, context).block();
    }

    /**
     * Disables the specified rule so it will not apply to a subscription in the future.
     * 
     * Description for Disables the specified rule so it will not apply to a subscription in the future.
     * 
     * @param name Rule name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void disableRecommendationForSubscription(String name) {
        disableRecommendationForSubscriptionWithResponse(name, Context.NONE);
    }

    /**
     * Get past recommendations for an app, optionally specified by the time range.
     * 
     * Description for Get past recommendations for an app, optionally specified by the time range.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param hostingEnvironmentName Name of the hosting environment.
     * @param expiredOnly Specify &lt;code&gt;false&lt;/code&gt; to return all recommendations. The default is
     * &lt;code&gt;true&lt;/code&gt;, which returns only expired recommendations.
     * @param filter Filter is specified by using OData syntax. Example: $filter=channel eq 'Api' or channel eq
     * 'Notification' and startTime eq 2014-01-01T00:00:00Z and endTime eq 2014-12-31T23:59:59Z and timeGrain eq
     * duration'[PT1H|PT1M|P1D].
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of recommendations along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RecommendationInner>> listHistoryForHostingEnvironmentSinglePageAsync(
        String resourceGroupName, String hostingEnvironmentName, Boolean expiredOnly, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (hostingEnvironmentName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter hostingEnvironmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listHistoryForHostingEnvironment(this.client.getEndpoint(),
                resourceGroupName, hostingEnvironmentName, expiredOnly, this.client.getSubscriptionId(),
                this.client.getApiVersion(), filter, accept, context))
            .<PagedResponse<RecommendationInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get past recommendations for an app, optionally specified by the time range.
     * 
     * Description for Get past recommendations for an app, optionally specified by the time range.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param hostingEnvironmentName Name of the hosting environment.
     * @param expiredOnly Specify &lt;code&gt;false&lt;/code&gt; to return all recommendations. The default is
     * &lt;code&gt;true&lt;/code&gt;, which returns only expired recommendations.
     * @param filter Filter is specified by using OData syntax. Example: $filter=channel eq 'Api' or channel eq
     * 'Notification' and startTime eq 2014-01-01T00:00:00Z and endTime eq 2014-12-31T23:59:59Z and timeGrain eq
     * duration'[PT1H|PT1M|P1D].
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of recommendations along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RecommendationInner>> listHistoryForHostingEnvironmentSinglePageAsync(
        String resourceGroupName, String hostingEnvironmentName, Boolean expiredOnly, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (hostingEnvironmentName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter hostingEnvironmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listHistoryForHostingEnvironment(this.client.getEndpoint(), resourceGroupName, hostingEnvironmentName,
                expiredOnly, this.client.getSubscriptionId(), this.client.getApiVersion(), filter, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get past recommendations for an app, optionally specified by the time range.
     * 
     * Description for Get past recommendations for an app, optionally specified by the time range.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param hostingEnvironmentName Name of the hosting environment.
     * @param expiredOnly Specify &lt;code&gt;false&lt;/code&gt; to return all recommendations. The default is
     * &lt;code&gt;true&lt;/code&gt;, which returns only expired recommendations.
     * @param filter Filter is specified by using OData syntax. Example: $filter=channel eq 'Api' or channel eq
     * 'Notification' and startTime eq 2014-01-01T00:00:00Z and endTime eq 2014-12-31T23:59:59Z and timeGrain eq
     * duration'[PT1H|PT1M|P1D].
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of recommendations as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<RecommendationInner> listHistoryForHostingEnvironmentAsync(String resourceGroupName,
        String hostingEnvironmentName, Boolean expiredOnly, String filter) {
        return new PagedFlux<>(() -> listHistoryForHostingEnvironmentSinglePageAsync(resourceGroupName,
            hostingEnvironmentName, expiredOnly, filter),
            nextLink -> listHistoryForHostingEnvironmentNextSinglePageAsync(nextLink));
    }

    /**
     * Get past recommendations for an app, optionally specified by the time range.
     * 
     * Description for Get past recommendations for an app, optionally specified by the time range.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param hostingEnvironmentName Name of the hosting environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of recommendations as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<RecommendationInner> listHistoryForHostingEnvironmentAsync(String resourceGroupName,
        String hostingEnvironmentName) {
        final Boolean expiredOnly = null;
        final String filter = null;
        return new PagedFlux<>(() -> listHistoryForHostingEnvironmentSinglePageAsync(resourceGroupName,
            hostingEnvironmentName, expiredOnly, filter),
            nextLink -> listHistoryForHostingEnvironmentNextSinglePageAsync(nextLink));
    }

    /**
     * Get past recommendations for an app, optionally specified by the time range.
     * 
     * Description for Get past recommendations for an app, optionally specified by the time range.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param hostingEnvironmentName Name of the hosting environment.
     * @param expiredOnly Specify &lt;code&gt;false&lt;/code&gt; to return all recommendations. The default is
     * &lt;code&gt;true&lt;/code&gt;, which returns only expired recommendations.
     * @param filter Filter is specified by using OData syntax. Example: $filter=channel eq 'Api' or channel eq
     * 'Notification' and startTime eq 2014-01-01T00:00:00Z and endTime eq 2014-12-31T23:59:59Z and timeGrain eq
     * duration'[PT1H|PT1M|P1D].
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of recommendations as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<RecommendationInner> listHistoryForHostingEnvironmentAsync(String resourceGroupName,
        String hostingEnvironmentName, Boolean expiredOnly, String filter, Context context) {
        return new PagedFlux<>(
            () -> listHistoryForHostingEnvironmentSinglePageAsync(resourceGroupName, hostingEnvironmentName,
                expiredOnly, filter, context),
            nextLink -> listHistoryForHostingEnvironmentNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get past recommendations for an app, optionally specified by the time range.
     * 
     * Description for Get past recommendations for an app, optionally specified by the time range.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param hostingEnvironmentName Name of the hosting environment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of recommendations as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<RecommendationInner> listHistoryForHostingEnvironment(String resourceGroupName,
        String hostingEnvironmentName) {
        final Boolean expiredOnly = null;
        final String filter = null;
        return new PagedIterable<>(
            listHistoryForHostingEnvironmentAsync(resourceGroupName, hostingEnvironmentName, expiredOnly, filter));
    }

    /**
     * Get past recommendations for an app, optionally specified by the time range.
     * 
     * Description for Get past recommendations for an app, optionally specified by the time range.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param hostingEnvironmentName Name of the hosting environment.
     * @param expiredOnly Specify &lt;code&gt;false&lt;/code&gt; to return all recommendations. The default is
     * &lt;code&gt;true&lt;/code&gt;, which returns only expired recommendations.
     * @param filter Filter is specified by using OData syntax. Example: $filter=channel eq 'Api' or channel eq
     * 'Notification' and startTime eq 2014-01-01T00:00:00Z and endTime eq 2014-12-31T23:59:59Z and timeGrain eq
     * duration'[PT1H|PT1M|P1D].
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of recommendations as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<RecommendationInner> listHistoryForHostingEnvironment(String resourceGroupName,
        String hostingEnvironmentName, Boolean expiredOnly, String filter, Context context) {
        return new PagedIterable<>(listHistoryForHostingEnvironmentAsync(resourceGroupName, hostingEnvironmentName,
            expiredOnly, filter, context));
    }

    /**
     * Get all recommendations for a hosting environment.
     * 
     * Description for Get all recommendations for a hosting environment.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param hostingEnvironmentName Name of the app.
     * @param featured Specify &lt;code&gt;true&lt;/code&gt; to return only the most critical recommendations. The
     * default is &lt;code&gt;false&lt;/code&gt;, which returns all recommendations.
     * @param filter Return only channels specified in the filter. Filter is specified by using OData syntax. Example:
     * $filter=channel eq 'Api' or channel eq 'Notification'.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of recommendations along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RecommendationInner>> listRecommendedRulesForHostingEnvironmentSinglePageAsync(
        String resourceGroupName, String hostingEnvironmentName, Boolean featured, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (hostingEnvironmentName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter hostingEnvironmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listRecommendedRulesForHostingEnvironment(this.client.getEndpoint(),
                resourceGroupName, hostingEnvironmentName, featured, this.client.getSubscriptionId(),
                this.client.getApiVersion(), filter, accept, context))
            .<PagedResponse<RecommendationInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get all recommendations for a hosting environment.
     * 
     * Description for Get all recommendations for a hosting environment.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param hostingEnvironmentName Name of the app.
     * @param featured Specify &lt;code&gt;true&lt;/code&gt; to return only the most critical recommendations. The
     * default is &lt;code&gt;false&lt;/code&gt;, which returns all recommendations.
     * @param filter Return only channels specified in the filter. Filter is specified by using OData syntax. Example:
     * $filter=channel eq 'Api' or channel eq 'Notification'.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of recommendations along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RecommendationInner>> listRecommendedRulesForHostingEnvironmentSinglePageAsync(
        String resourceGroupName, String hostingEnvironmentName, Boolean featured, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (hostingEnvironmentName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter hostingEnvironmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listRecommendedRulesForHostingEnvironment(this.client.getEndpoint(), resourceGroupName,
                hostingEnvironmentName, featured, this.client.getSubscriptionId(), this.client.getApiVersion(), filter,
                accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get all recommendations for a hosting environment.
     * 
     * Description for Get all recommendations for a hosting environment.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param hostingEnvironmentName Name of the app.
     * @param featured Specify &lt;code&gt;true&lt;/code&gt; to return only the most critical recommendations. The
     * default is &lt;code&gt;false&lt;/code&gt;, which returns all recommendations.
     * @param filter Return only channels specified in the filter. Filter is specified by using OData syntax. Example:
     * $filter=channel eq 'Api' or channel eq 'Notification'.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of recommendations as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<RecommendationInner> listRecommendedRulesForHostingEnvironmentAsync(String resourceGroupName,
        String hostingEnvironmentName, Boolean featured, String filter) {
        return new PagedFlux<>(() -> listRecommendedRulesForHostingEnvironmentSinglePageAsync(resourceGroupName,
            hostingEnvironmentName, featured, filter),
            nextLink -> listRecommendedRulesForHostingEnvironmentNextSinglePageAsync(nextLink));
    }

    /**
     * Get all recommendations for a hosting environment.
     * 
     * Description for Get all recommendations for a hosting environment.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param hostingEnvironmentName Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of recommendations as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<RecommendationInner> listRecommendedRulesForHostingEnvironmentAsync(String resourceGroupName,
        String hostingEnvironmentName) {
        final Boolean featured = null;
        final String filter = null;
        return new PagedFlux<>(() -> listRecommendedRulesForHostingEnvironmentSinglePageAsync(resourceGroupName,
            hostingEnvironmentName, featured, filter),
            nextLink -> listRecommendedRulesForHostingEnvironmentNextSinglePageAsync(nextLink));
    }

    /**
     * Get all recommendations for a hosting environment.
     * 
     * Description for Get all recommendations for a hosting environment.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param hostingEnvironmentName Name of the app.
     * @param featured Specify &lt;code&gt;true&lt;/code&gt; to return only the most critical recommendations. The
     * default is &lt;code&gt;false&lt;/code&gt;, which returns all recommendations.
     * @param filter Return only channels specified in the filter. Filter is specified by using OData syntax. Example:
     * $filter=channel eq 'Api' or channel eq 'Notification'.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of recommendations as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<RecommendationInner> listRecommendedRulesForHostingEnvironmentAsync(String resourceGroupName,
        String hostingEnvironmentName, Boolean featured, String filter, Context context) {
        return new PagedFlux<>(
            () -> listRecommendedRulesForHostingEnvironmentSinglePageAsync(resourceGroupName, hostingEnvironmentName,
                featured, filter, context),
            nextLink -> listRecommendedRulesForHostingEnvironmentNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get all recommendations for a hosting environment.
     * 
     * Description for Get all recommendations for a hosting environment.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param hostingEnvironmentName Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of recommendations as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<RecommendationInner> listRecommendedRulesForHostingEnvironment(String resourceGroupName,
        String hostingEnvironmentName) {
        final Boolean featured = null;
        final String filter = null;
        return new PagedIterable<>(listRecommendedRulesForHostingEnvironmentAsync(resourceGroupName,
            hostingEnvironmentName, featured, filter));
    }

    /**
     * Get all recommendations for a hosting environment.
     * 
     * Description for Get all recommendations for a hosting environment.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param hostingEnvironmentName Name of the app.
     * @param featured Specify &lt;code&gt;true&lt;/code&gt; to return only the most critical recommendations. The
     * default is &lt;code&gt;false&lt;/code&gt;, which returns all recommendations.
     * @param filter Return only channels specified in the filter. Filter is specified by using OData syntax. Example:
     * $filter=channel eq 'Api' or channel eq 'Notification'.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of recommendations as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<RecommendationInner> listRecommendedRulesForHostingEnvironment(String resourceGroupName,
        String hostingEnvironmentName, Boolean featured, String filter, Context context) {
        return new PagedIterable<>(listRecommendedRulesForHostingEnvironmentAsync(resourceGroupName,
            hostingEnvironmentName, featured, filter, context));
    }

    /**
     * Disable all recommendations for an app.
     * 
     * Description for Disable all recommendations for an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param environmentName Name of the app.
     * @param hostingEnvironmentName The hostingEnvironmentName parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> disableAllForHostingEnvironmentWithResponseAsync(String resourceGroupName,
        String environmentName, String hostingEnvironmentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (hostingEnvironmentName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter hostingEnvironmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.disableAllForHostingEnvironment(this.client.getEndpoint(),
                resourceGroupName, environmentName, hostingEnvironmentName, this.client.getSubscriptionId(),
                this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Disable all recommendations for an app.
     * 
     * Description for Disable all recommendations for an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param environmentName Name of the app.
     * @param hostingEnvironmentName The hostingEnvironmentName parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> disableAllForHostingEnvironmentWithResponseAsync(String resourceGroupName,
        String environmentName, String hostingEnvironmentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (hostingEnvironmentName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter hostingEnvironmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.disableAllForHostingEnvironment(this.client.getEndpoint(), resourceGroupName, environmentName,
            hostingEnvironmentName, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Disable all recommendations for an app.
     * 
     * Description for Disable all recommendations for an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param environmentName Name of the app.
     * @param hostingEnvironmentName The hostingEnvironmentName parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> disableAllForHostingEnvironmentAsync(String resourceGroupName, String environmentName,
        String hostingEnvironmentName) {
        return disableAllForHostingEnvironmentWithResponseAsync(resourceGroupName, environmentName,
            hostingEnvironmentName).flatMap(ignored -> Mono.empty());
    }

    /**
     * Disable all recommendations for an app.
     * 
     * Description for Disable all recommendations for an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param environmentName Name of the app.
     * @param hostingEnvironmentName The hostingEnvironmentName parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> disableAllForHostingEnvironmentWithResponse(String resourceGroupName, String environmentName,
        String hostingEnvironmentName, Context context) {
        return disableAllForHostingEnvironmentWithResponseAsync(resourceGroupName, environmentName,
            hostingEnvironmentName, context).block();
    }

    /**
     * Disable all recommendations for an app.
     * 
     * Description for Disable all recommendations for an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param environmentName Name of the app.
     * @param hostingEnvironmentName The hostingEnvironmentName parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void disableAllForHostingEnvironment(String resourceGroupName, String environmentName,
        String hostingEnvironmentName) {
        disableAllForHostingEnvironmentWithResponse(resourceGroupName, environmentName, hostingEnvironmentName,
            Context.NONE);
    }

    /**
     * Reset all recommendation opt-out settings for an app.
     * 
     * Description for Reset all recommendation opt-out settings for an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param environmentName Name of the app.
     * @param hostingEnvironmentName The hostingEnvironmentName parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> resetAllFiltersForHostingEnvironmentWithResponseAsync(String resourceGroupName,
        String environmentName, String hostingEnvironmentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (hostingEnvironmentName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter hostingEnvironmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.resetAllFiltersForHostingEnvironment(this.client.getEndpoint(),
                resourceGroupName, environmentName, hostingEnvironmentName, this.client.getSubscriptionId(),
                this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Reset all recommendation opt-out settings for an app.
     * 
     * Description for Reset all recommendation opt-out settings for an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param environmentName Name of the app.
     * @param hostingEnvironmentName The hostingEnvironmentName parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> resetAllFiltersForHostingEnvironmentWithResponseAsync(String resourceGroupName,
        String environmentName, String hostingEnvironmentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (hostingEnvironmentName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter hostingEnvironmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.resetAllFiltersForHostingEnvironment(this.client.getEndpoint(), resourceGroupName,
            environmentName, hostingEnvironmentName, this.client.getSubscriptionId(), this.client.getApiVersion(),
            accept, context);
    }

    /**
     * Reset all recommendation opt-out settings for an app.
     * 
     * Description for Reset all recommendation opt-out settings for an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param environmentName Name of the app.
     * @param hostingEnvironmentName The hostingEnvironmentName parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> resetAllFiltersForHostingEnvironmentAsync(String resourceGroupName, String environmentName,
        String hostingEnvironmentName) {
        return resetAllFiltersForHostingEnvironmentWithResponseAsync(resourceGroupName, environmentName,
            hostingEnvironmentName).flatMap(ignored -> Mono.empty());
    }

    /**
     * Reset all recommendation opt-out settings for an app.
     * 
     * Description for Reset all recommendation opt-out settings for an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param environmentName Name of the app.
     * @param hostingEnvironmentName The hostingEnvironmentName parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> resetAllFiltersForHostingEnvironmentWithResponse(String resourceGroupName,
        String environmentName, String hostingEnvironmentName, Context context) {
        return resetAllFiltersForHostingEnvironmentWithResponseAsync(resourceGroupName, environmentName,
            hostingEnvironmentName, context).block();
    }

    /**
     * Reset all recommendation opt-out settings for an app.
     * 
     * Description for Reset all recommendation opt-out settings for an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param environmentName Name of the app.
     * @param hostingEnvironmentName The hostingEnvironmentName parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void resetAllFiltersForHostingEnvironment(String resourceGroupName, String environmentName,
        String hostingEnvironmentName) {
        resetAllFiltersForHostingEnvironmentWithResponse(resourceGroupName, environmentName, hostingEnvironmentName,
            Context.NONE);
    }

    /**
     * Get a recommendation rule for an app.
     * 
     * Description for Get a recommendation rule for an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param hostingEnvironmentName Name of the hosting environment.
     * @param name Name of the recommendation.
     * @param updateSeen Specify &lt;code&gt;true&lt;/code&gt; to update the last-seen timestamp of the recommendation
     * object.
     * @param recommendationId The GUID of the recommendation object if you query an expired one. You don't need to
     * specify it to query an active entry.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a recommendation rule that the recommendation engine can perform along with {@link Response}
     * on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<RecommendationRuleInner>> getRuleDetailsByHostingEnvironmentWithResponseAsync(
        String resourceGroupName, String hostingEnvironmentName, String name, Boolean updateSeen,
        String recommendationId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (hostingEnvironmentName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter hostingEnvironmentName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getRuleDetailsByHostingEnvironment(this.client.getEndpoint(),
                resourceGroupName, hostingEnvironmentName, name, updateSeen, recommendationId,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get a recommendation rule for an app.
     * 
     * Description for Get a recommendation rule for an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param hostingEnvironmentName Name of the hosting environment.
     * @param name Name of the recommendation.
     * @param updateSeen Specify &lt;code&gt;true&lt;/code&gt; to update the last-seen timestamp of the recommendation
     * object.
     * @param recommendationId The GUID of the recommendation object if you query an expired one. You don't need to
     * specify it to query an active entry.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a recommendation rule that the recommendation engine can perform along with {@link Response}
     * on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<RecommendationRuleInner>> getRuleDetailsByHostingEnvironmentWithResponseAsync(
        String resourceGroupName, String hostingEnvironmentName, String name, Boolean updateSeen,
        String recommendationId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (hostingEnvironmentName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter hostingEnvironmentName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getRuleDetailsByHostingEnvironment(this.client.getEndpoint(), resourceGroupName,
            hostingEnvironmentName, name, updateSeen, recommendationId, this.client.getSubscriptionId(),
            this.client.getApiVersion(), accept, context);
    }

    /**
     * Get a recommendation rule for an app.
     * 
     * Description for Get a recommendation rule for an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param hostingEnvironmentName Name of the hosting environment.
     * @param name Name of the recommendation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a recommendation rule that the recommendation engine can perform on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<RecommendationRuleInner> getRuleDetailsByHostingEnvironmentAsync(String resourceGroupName,
        String hostingEnvironmentName, String name) {
        final Boolean updateSeen = null;
        final String recommendationId = null;
        return getRuleDetailsByHostingEnvironmentWithResponseAsync(resourceGroupName, hostingEnvironmentName, name,
            updateSeen, recommendationId).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get a recommendation rule for an app.
     * 
     * Description for Get a recommendation rule for an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param hostingEnvironmentName Name of the hosting environment.
     * @param name Name of the recommendation.
     * @param updateSeen Specify &lt;code&gt;true&lt;/code&gt; to update the last-seen timestamp of the recommendation
     * object.
     * @param recommendationId The GUID of the recommendation object if you query an expired one. You don't need to
     * specify it to query an active entry.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a recommendation rule that the recommendation engine can perform along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<RecommendationRuleInner> getRuleDetailsByHostingEnvironmentWithResponse(String resourceGroupName,
        String hostingEnvironmentName, String name, Boolean updateSeen, String recommendationId, Context context) {
        return getRuleDetailsByHostingEnvironmentWithResponseAsync(resourceGroupName, hostingEnvironmentName, name,
            updateSeen, recommendationId, context).block();
    }

    /**
     * Get a recommendation rule for an app.
     * 
     * Description for Get a recommendation rule for an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param hostingEnvironmentName Name of the hosting environment.
     * @param name Name of the recommendation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a recommendation rule that the recommendation engine can perform.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public RecommendationRuleInner getRuleDetailsByHostingEnvironment(String resourceGroupName,
        String hostingEnvironmentName, String name) {
        final Boolean updateSeen = null;
        final String recommendationId = null;
        return getRuleDetailsByHostingEnvironmentWithResponse(resourceGroupName, hostingEnvironmentName, name,
            updateSeen, recommendationId, Context.NONE).getValue();
    }

    /**
     * Disables the specific rule for a web site permanently.
     * 
     * Description for Disables the specific rule for a web site permanently.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param environmentName Site name.
     * @param name Rule name.
     * @param hostingEnvironmentName The hostingEnvironmentName parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> disableRecommendationForHostingEnvironmentWithResponseAsync(String resourceGroupName,
        String environmentName, String name, String hostingEnvironmentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (hostingEnvironmentName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter hostingEnvironmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.disableRecommendationForHostingEnvironment(this.client.getEndpoint(),
                resourceGroupName, environmentName, name, hostingEnvironmentName, this.client.getSubscriptionId(),
                this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Disables the specific rule for a web site permanently.
     * 
     * Description for Disables the specific rule for a web site permanently.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param environmentName Site name.
     * @param name Rule name.
     * @param hostingEnvironmentName The hostingEnvironmentName parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> disableRecommendationForHostingEnvironmentWithResponseAsync(String resourceGroupName,
        String environmentName, String name, String hostingEnvironmentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (environmentName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter environmentName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (hostingEnvironmentName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter hostingEnvironmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.disableRecommendationForHostingEnvironment(this.client.getEndpoint(), resourceGroupName,
            environmentName, name, hostingEnvironmentName, this.client.getSubscriptionId(), this.client.getApiVersion(),
            accept, context);
    }

    /**
     * Disables the specific rule for a web site permanently.
     * 
     * Description for Disables the specific rule for a web site permanently.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param environmentName Site name.
     * @param name Rule name.
     * @param hostingEnvironmentName The hostingEnvironmentName parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> disableRecommendationForHostingEnvironmentAsync(String resourceGroupName, String environmentName,
        String name, String hostingEnvironmentName) {
        return disableRecommendationForHostingEnvironmentWithResponseAsync(resourceGroupName, environmentName, name,
            hostingEnvironmentName).flatMap(ignored -> Mono.empty());
    }

    /**
     * Disables the specific rule for a web site permanently.
     * 
     * Description for Disables the specific rule for a web site permanently.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param environmentName Site name.
     * @param name Rule name.
     * @param hostingEnvironmentName The hostingEnvironmentName parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> disableRecommendationForHostingEnvironmentWithResponse(String resourceGroupName,
        String environmentName, String name, String hostingEnvironmentName, Context context) {
        return disableRecommendationForHostingEnvironmentWithResponseAsync(resourceGroupName, environmentName, name,
            hostingEnvironmentName, context).block();
    }

    /**
     * Disables the specific rule for a web site permanently.
     * 
     * Description for Disables the specific rule for a web site permanently.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param environmentName Site name.
     * @param name Rule name.
     * @param hostingEnvironmentName The hostingEnvironmentName parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void disableRecommendationForHostingEnvironment(String resourceGroupName, String environmentName,
        String name, String hostingEnvironmentName) {
        disableRecommendationForHostingEnvironmentWithResponse(resourceGroupName, environmentName, name,
            hostingEnvironmentName, Context.NONE);
    }

    /**
     * Get past recommendations for an app, optionally specified by the time range.
     * 
     * Description for Get past recommendations for an app, optionally specified by the time range.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Name of the app.
     * @param expiredOnly Specify &lt;code&gt;false&lt;/code&gt; to return all recommendations. The default is
     * &lt;code&gt;true&lt;/code&gt;, which returns only expired recommendations.
     * @param filter Filter is specified by using OData syntax. Example: $filter=channel eq 'Api' or channel eq
     * 'Notification' and startTime eq 2014-01-01T00:00:00Z and endTime eq 2014-12-31T23:59:59Z and timeGrain eq
     * duration'[PT1H|PT1M|P1D].
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of recommendations along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RecommendationInner>> listHistoryForWebAppSinglePageAsync(String resourceGroupName,
        String siteName, Boolean expiredOnly, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listHistoryForWebApp(this.client.getEndpoint(), resourceGroupName, siteName,
                expiredOnly, this.client.getSubscriptionId(), this.client.getApiVersion(), filter, accept, context))
            .<PagedResponse<RecommendationInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get past recommendations for an app, optionally specified by the time range.
     * 
     * Description for Get past recommendations for an app, optionally specified by the time range.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Name of the app.
     * @param expiredOnly Specify &lt;code&gt;false&lt;/code&gt; to return all recommendations. The default is
     * &lt;code&gt;true&lt;/code&gt;, which returns only expired recommendations.
     * @param filter Filter is specified by using OData syntax. Example: $filter=channel eq 'Api' or channel eq
     * 'Notification' and startTime eq 2014-01-01T00:00:00Z and endTime eq 2014-12-31T23:59:59Z and timeGrain eq
     * duration'[PT1H|PT1M|P1D].
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of recommendations along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RecommendationInner>> listHistoryForWebAppSinglePageAsync(String resourceGroupName,
        String siteName, Boolean expiredOnly, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listHistoryForWebApp(this.client.getEndpoint(), resourceGroupName, siteName, expiredOnly,
                this.client.getSubscriptionId(), this.client.getApiVersion(), filter, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get past recommendations for an app, optionally specified by the time range.
     * 
     * Description for Get past recommendations for an app, optionally specified by the time range.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Name of the app.
     * @param expiredOnly Specify &lt;code&gt;false&lt;/code&gt; to return all recommendations. The default is
     * &lt;code&gt;true&lt;/code&gt;, which returns only expired recommendations.
     * @param filter Filter is specified by using OData syntax. Example: $filter=channel eq 'Api' or channel eq
     * 'Notification' and startTime eq 2014-01-01T00:00:00Z and endTime eq 2014-12-31T23:59:59Z and timeGrain eq
     * duration'[PT1H|PT1M|P1D].
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of recommendations as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<RecommendationInner> listHistoryForWebAppAsync(String resourceGroupName, String siteName,
        Boolean expiredOnly, String filter) {
        return new PagedFlux<>(
            () -> listHistoryForWebAppSinglePageAsync(resourceGroupName, siteName, expiredOnly, filter),
            nextLink -> listHistoryForWebAppNextSinglePageAsync(nextLink));
    }

    /**
     * Get past recommendations for an app, optionally specified by the time range.
     * 
     * Description for Get past recommendations for an app, optionally specified by the time range.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of recommendations as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<RecommendationInner> listHistoryForWebAppAsync(String resourceGroupName, String siteName) {
        final Boolean expiredOnly = null;
        final String filter = null;
        return new PagedFlux<>(
            () -> listHistoryForWebAppSinglePageAsync(resourceGroupName, siteName, expiredOnly, filter),
            nextLink -> listHistoryForWebAppNextSinglePageAsync(nextLink));
    }

    /**
     * Get past recommendations for an app, optionally specified by the time range.
     * 
     * Description for Get past recommendations for an app, optionally specified by the time range.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Name of the app.
     * @param expiredOnly Specify &lt;code&gt;false&lt;/code&gt; to return all recommendations. The default is
     * &lt;code&gt;true&lt;/code&gt;, which returns only expired recommendations.
     * @param filter Filter is specified by using OData syntax. Example: $filter=channel eq 'Api' or channel eq
     * 'Notification' and startTime eq 2014-01-01T00:00:00Z and endTime eq 2014-12-31T23:59:59Z and timeGrain eq
     * duration'[PT1H|PT1M|P1D].
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of recommendations as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<RecommendationInner> listHistoryForWebAppAsync(String resourceGroupName, String siteName,
        Boolean expiredOnly, String filter, Context context) {
        return new PagedFlux<>(
            () -> listHistoryForWebAppSinglePageAsync(resourceGroupName, siteName, expiredOnly, filter, context),
            nextLink -> listHistoryForWebAppNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get past recommendations for an app, optionally specified by the time range.
     * 
     * Description for Get past recommendations for an app, optionally specified by the time range.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of recommendations as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<RecommendationInner> listHistoryForWebApp(String resourceGroupName, String siteName) {
        final Boolean expiredOnly = null;
        final String filter = null;
        return new PagedIterable<>(listHistoryForWebAppAsync(resourceGroupName, siteName, expiredOnly, filter));
    }

    /**
     * Get past recommendations for an app, optionally specified by the time range.
     * 
     * Description for Get past recommendations for an app, optionally specified by the time range.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Name of the app.
     * @param expiredOnly Specify &lt;code&gt;false&lt;/code&gt; to return all recommendations. The default is
     * &lt;code&gt;true&lt;/code&gt;, which returns only expired recommendations.
     * @param filter Filter is specified by using OData syntax. Example: $filter=channel eq 'Api' or channel eq
     * 'Notification' and startTime eq 2014-01-01T00:00:00Z and endTime eq 2014-12-31T23:59:59Z and timeGrain eq
     * duration'[PT1H|PT1M|P1D].
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of recommendations as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<RecommendationInner> listHistoryForWebApp(String resourceGroupName, String siteName,
        Boolean expiredOnly, String filter, Context context) {
        return new PagedIterable<>(
            listHistoryForWebAppAsync(resourceGroupName, siteName, expiredOnly, filter, context));
    }

    /**
     * Get all recommendations for an app.
     * 
     * Description for Get all recommendations for an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Name of the app.
     * @param featured Specify &lt;code&gt;true&lt;/code&gt; to return only the most critical recommendations. The
     * default is &lt;code&gt;false&lt;/code&gt;, which returns all recommendations.
     * @param filter Return only channels specified in the filter. Filter is specified by using OData syntax. Example:
     * $filter=channel eq 'Api' or channel eq 'Notification'.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of recommendations along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RecommendationInner>> listRecommendedRulesForWebAppSinglePageAsync(
        String resourceGroupName, String siteName, Boolean featured, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listRecommendedRulesForWebApp(this.client.getEndpoint(), resourceGroupName, siteName,
                    featured, this.client.getSubscriptionId(), this.client.getApiVersion(), filter, accept, context))
            .<PagedResponse<RecommendationInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get all recommendations for an app.
     * 
     * Description for Get all recommendations for an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Name of the app.
     * @param featured Specify &lt;code&gt;true&lt;/code&gt; to return only the most critical recommendations. The
     * default is &lt;code&gt;false&lt;/code&gt;, which returns all recommendations.
     * @param filter Return only channels specified in the filter. Filter is specified by using OData syntax. Example:
     * $filter=channel eq 'Api' or channel eq 'Notification'.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of recommendations along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RecommendationInner>> listRecommendedRulesForWebAppSinglePageAsync(
        String resourceGroupName, String siteName, Boolean featured, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listRecommendedRulesForWebApp(this.client.getEndpoint(), resourceGroupName, siteName, featured,
                this.client.getSubscriptionId(), this.client.getApiVersion(), filter, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get all recommendations for an app.
     * 
     * Description for Get all recommendations for an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Name of the app.
     * @param featured Specify &lt;code&gt;true&lt;/code&gt; to return only the most critical recommendations. The
     * default is &lt;code&gt;false&lt;/code&gt;, which returns all recommendations.
     * @param filter Return only channels specified in the filter. Filter is specified by using OData syntax. Example:
     * $filter=channel eq 'Api' or channel eq 'Notification'.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of recommendations as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<RecommendationInner> listRecommendedRulesForWebAppAsync(String resourceGroupName, String siteName,
        Boolean featured, String filter) {
        return new PagedFlux<>(
            () -> listRecommendedRulesForWebAppSinglePageAsync(resourceGroupName, siteName, featured, filter),
            nextLink -> listRecommendedRulesForWebAppNextSinglePageAsync(nextLink));
    }

    /**
     * Get all recommendations for an app.
     * 
     * Description for Get all recommendations for an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of recommendations as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<RecommendationInner> listRecommendedRulesForWebAppAsync(String resourceGroupName,
        String siteName) {
        final Boolean featured = null;
        final String filter = null;
        return new PagedFlux<>(
            () -> listRecommendedRulesForWebAppSinglePageAsync(resourceGroupName, siteName, featured, filter),
            nextLink -> listRecommendedRulesForWebAppNextSinglePageAsync(nextLink));
    }

    /**
     * Get all recommendations for an app.
     * 
     * Description for Get all recommendations for an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Name of the app.
     * @param featured Specify &lt;code&gt;true&lt;/code&gt; to return only the most critical recommendations. The
     * default is &lt;code&gt;false&lt;/code&gt;, which returns all recommendations.
     * @param filter Return only channels specified in the filter. Filter is specified by using OData syntax. Example:
     * $filter=channel eq 'Api' or channel eq 'Notification'.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of recommendations as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<RecommendationInner> listRecommendedRulesForWebAppAsync(String resourceGroupName, String siteName,
        Boolean featured, String filter, Context context) {
        return new PagedFlux<>(
            () -> listRecommendedRulesForWebAppSinglePageAsync(resourceGroupName, siteName, featured, filter, context),
            nextLink -> listRecommendedRulesForWebAppNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get all recommendations for an app.
     * 
     * Description for Get all recommendations for an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of recommendations as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<RecommendationInner> listRecommendedRulesForWebApp(String resourceGroupName, String siteName) {
        final Boolean featured = null;
        final String filter = null;
        return new PagedIterable<>(listRecommendedRulesForWebAppAsync(resourceGroupName, siteName, featured, filter));
    }

    /**
     * Get all recommendations for an app.
     * 
     * Description for Get all recommendations for an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Name of the app.
     * @param featured Specify &lt;code&gt;true&lt;/code&gt; to return only the most critical recommendations. The
     * default is &lt;code&gt;false&lt;/code&gt;, which returns all recommendations.
     * @param filter Return only channels specified in the filter. Filter is specified by using OData syntax. Example:
     * $filter=channel eq 'Api' or channel eq 'Notification'.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of recommendations as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<RecommendationInner> listRecommendedRulesForWebApp(String resourceGroupName, String siteName,
        Boolean featured, String filter, Context context) {
        return new PagedIterable<>(
            listRecommendedRulesForWebAppAsync(resourceGroupName, siteName, featured, filter, context));
    }

    /**
     * Disable all recommendations for an app.
     * 
     * Description for Disable all recommendations for an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> disableAllForWebAppWithResponseAsync(String resourceGroupName, String siteName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.disableAllForWebApp(this.client.getEndpoint(), resourceGroupName, siteName,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Disable all recommendations for an app.
     * 
     * Description for Disable all recommendations for an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> disableAllForWebAppWithResponseAsync(String resourceGroupName, String siteName,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.disableAllForWebApp(this.client.getEndpoint(), resourceGroupName, siteName,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Disable all recommendations for an app.
     * 
     * Description for Disable all recommendations for an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> disableAllForWebAppAsync(String resourceGroupName, String siteName) {
        return disableAllForWebAppWithResponseAsync(resourceGroupName, siteName).flatMap(ignored -> Mono.empty());
    }

    /**
     * Disable all recommendations for an app.
     * 
     * Description for Disable all recommendations for an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> disableAllForWebAppWithResponse(String resourceGroupName, String siteName, Context context) {
        return disableAllForWebAppWithResponseAsync(resourceGroupName, siteName, context).block();
    }

    /**
     * Disable all recommendations for an app.
     * 
     * Description for Disable all recommendations for an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void disableAllForWebApp(String resourceGroupName, String siteName) {
        disableAllForWebAppWithResponse(resourceGroupName, siteName, Context.NONE);
    }

    /**
     * Reset all recommendation opt-out settings for an app.
     * 
     * Description for Reset all recommendation opt-out settings for an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> resetAllFiltersForWebAppWithResponseAsync(String resourceGroupName, String siteName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.resetAllFiltersForWebApp(this.client.getEndpoint(), resourceGroupName,
                siteName, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Reset all recommendation opt-out settings for an app.
     * 
     * Description for Reset all recommendation opt-out settings for an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> resetAllFiltersForWebAppWithResponseAsync(String resourceGroupName, String siteName,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.resetAllFiltersForWebApp(this.client.getEndpoint(), resourceGroupName, siteName,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Reset all recommendation opt-out settings for an app.
     * 
     * Description for Reset all recommendation opt-out settings for an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> resetAllFiltersForWebAppAsync(String resourceGroupName, String siteName) {
        return resetAllFiltersForWebAppWithResponseAsync(resourceGroupName, siteName).flatMap(ignored -> Mono.empty());
    }

    /**
     * Reset all recommendation opt-out settings for an app.
     * 
     * Description for Reset all recommendation opt-out settings for an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> resetAllFiltersForWebAppWithResponse(String resourceGroupName, String siteName,
        Context context) {
        return resetAllFiltersForWebAppWithResponseAsync(resourceGroupName, siteName, context).block();
    }

    /**
     * Reset all recommendation opt-out settings for an app.
     * 
     * Description for Reset all recommendation opt-out settings for an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void resetAllFiltersForWebApp(String resourceGroupName, String siteName) {
        resetAllFiltersForWebAppWithResponse(resourceGroupName, siteName, Context.NONE);
    }

    /**
     * Get a recommendation rule for an app.
     * 
     * Description for Get a recommendation rule for an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Name of the app.
     * @param name Name of the recommendation.
     * @param updateSeen Specify &lt;code&gt;true&lt;/code&gt; to update the last-seen timestamp of the recommendation
     * object.
     * @param recommendationId The GUID of the recommendation object if you query an expired one. You don't need to
     * specify it to query an active entry.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a recommendation rule that the recommendation engine can perform along with {@link Response}
     * on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<RecommendationRuleInner>> getRuleDetailsByWebAppWithResponseAsync(String resourceGroupName,
        String siteName, String name, Boolean updateSeen, String recommendationId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getRuleDetailsByWebApp(this.client.getEndpoint(), resourceGroupName,
                siteName, name, updateSeen, recommendationId, this.client.getSubscriptionId(),
                this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get a recommendation rule for an app.
     * 
     * Description for Get a recommendation rule for an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Name of the app.
     * @param name Name of the recommendation.
     * @param updateSeen Specify &lt;code&gt;true&lt;/code&gt; to update the last-seen timestamp of the recommendation
     * object.
     * @param recommendationId The GUID of the recommendation object if you query an expired one. You don't need to
     * specify it to query an active entry.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a recommendation rule that the recommendation engine can perform along with {@link Response}
     * on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<RecommendationRuleInner>> getRuleDetailsByWebAppWithResponseAsync(String resourceGroupName,
        String siteName, String name, Boolean updateSeen, String recommendationId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getRuleDetailsByWebApp(this.client.getEndpoint(), resourceGroupName, siteName, name, updateSeen,
            recommendationId, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Get a recommendation rule for an app.
     * 
     * Description for Get a recommendation rule for an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Name of the app.
     * @param name Name of the recommendation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a recommendation rule that the recommendation engine can perform on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<RecommendationRuleInner> getRuleDetailsByWebAppAsync(String resourceGroupName, String siteName,
        String name) {
        final Boolean updateSeen = null;
        final String recommendationId = null;
        return getRuleDetailsByWebAppWithResponseAsync(resourceGroupName, siteName, name, updateSeen, recommendationId)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get a recommendation rule for an app.
     * 
     * Description for Get a recommendation rule for an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Name of the app.
     * @param name Name of the recommendation.
     * @param updateSeen Specify &lt;code&gt;true&lt;/code&gt; to update the last-seen timestamp of the recommendation
     * object.
     * @param recommendationId The GUID of the recommendation object if you query an expired one. You don't need to
     * specify it to query an active entry.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a recommendation rule that the recommendation engine can perform along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<RecommendationRuleInner> getRuleDetailsByWebAppWithResponse(String resourceGroupName,
        String siteName, String name, Boolean updateSeen, String recommendationId, Context context) {
        return getRuleDetailsByWebAppWithResponseAsync(resourceGroupName, siteName, name, updateSeen, recommendationId,
            context).block();
    }

    /**
     * Get a recommendation rule for an app.
     * 
     * Description for Get a recommendation rule for an app.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Name of the app.
     * @param name Name of the recommendation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents a recommendation rule that the recommendation engine can perform.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public RecommendationRuleInner getRuleDetailsByWebApp(String resourceGroupName, String siteName, String name) {
        final Boolean updateSeen = null;
        final String recommendationId = null;
        return getRuleDetailsByWebAppWithResponse(resourceGroupName, siteName, name, updateSeen, recommendationId,
            Context.NONE).getValue();
    }

    /**
     * Disables the specific rule for a web site permanently.
     * 
     * Description for Disables the specific rule for a web site permanently.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site name.
     * @param name Rule name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> disableRecommendationForSiteWithResponseAsync(String resourceGroupName, String siteName,
        String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.disableRecommendationForSite(this.client.getEndpoint(), resourceGroupName,
                siteName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Disables the specific rule for a web site permanently.
     * 
     * Description for Disables the specific rule for a web site permanently.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site name.
     * @param name Rule name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> disableRecommendationForSiteWithResponseAsync(String resourceGroupName,
        String siteName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (siteName == null) {
            return Mono.error(new IllegalArgumentException("Parameter siteName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error(new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.disableRecommendationForSite(this.client.getEndpoint(), resourceGroupName, siteName, name,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Disables the specific rule for a web site permanently.
     * 
     * Description for Disables the specific rule for a web site permanently.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site name.
     * @param name Rule name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> disableRecommendationForSiteAsync(String resourceGroupName, String siteName, String name) {
        return disableRecommendationForSiteWithResponseAsync(resourceGroupName, siteName, name)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Disables the specific rule for a web site permanently.
     * 
     * Description for Disables the specific rule for a web site permanently.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site name.
     * @param name Rule name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> disableRecommendationForSiteWithResponse(String resourceGroupName, String siteName,
        String name, Context context) {
        return disableRecommendationForSiteWithResponseAsync(resourceGroupName, siteName, name, context).block();
    }

    /**
     * Disables the specific rule for a web site permanently.
     * 
     * Description for Disables the specific rule for a web site permanently.
     * 
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param siteName Site name.
     * @param name Rule name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void disableRecommendationForSite(String resourceGroupName, String siteName, String name) {
        disableRecommendationForSiteWithResponse(resourceGroupName, siteName, name, Context.NONE);
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of recommendations along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RecommendationInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.listNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<RecommendationInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of recommendations along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RecommendationInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of recommendations along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RecommendationInner>>
        listHistoryForHostingEnvironmentNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listHistoryForHostingEnvironmentNext(nextLink, this.client.getEndpoint(),
                accept, context))
            .<PagedResponse<RecommendationInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of recommendations along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RecommendationInner>>
        listHistoryForHostingEnvironmentNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listHistoryForHostingEnvironmentNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of recommendations along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RecommendationInner>>
        listRecommendedRulesForHostingEnvironmentNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listRecommendedRulesForHostingEnvironmentNext(nextLink,
                this.client.getEndpoint(), accept, context))
            .<PagedResponse<RecommendationInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of recommendations along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RecommendationInner>>
        listRecommendedRulesForHostingEnvironmentNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listRecommendedRulesForHostingEnvironmentNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of recommendations along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RecommendationInner>> listHistoryForWebAppNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listHistoryForWebAppNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<RecommendationInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of recommendations along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RecommendationInner>> listHistoryForWebAppNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listHistoryForWebAppNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of recommendations along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RecommendationInner>> listRecommendedRulesForWebAppNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil.withContext(
            context -> service.listRecommendedRulesForWebAppNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<RecommendationInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws DefaultErrorResponseErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of recommendations along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RecommendationInner>> listRecommendedRulesForWebAppNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listRecommendedRulesForWebAppNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }
}
