// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import java.io.IOException;
import java.util.List;

/**
 * Static site basic auth properties ARM resource.
 */
@Fluent
public final class StaticSiteBasicAuthPropertiesArmResourceInner extends ProxyOnlyResource {
    /*
     * StaticSiteBasicAuthPropertiesARMResource resource specific properties
     */
    private StaticSiteBasicAuthPropertiesArmResourceProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of StaticSiteBasicAuthPropertiesArmResourceInner class.
     */
    public StaticSiteBasicAuthPropertiesArmResourceInner() {
    }

    /**
     * Get the innerProperties property: StaticSiteBasicAuthPropertiesARMResource resource specific properties.
     * 
     * @return the innerProperties value.
     */
    private StaticSiteBasicAuthPropertiesArmResourceProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public StaticSiteBasicAuthPropertiesArmResourceInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the password property: The password for basic auth.
     * 
     * @return the password value.
     */
    public String password() {
        return this.innerProperties() == null ? null : this.innerProperties().password();
    }

    /**
     * Set the password property: The password for basic auth.
     * 
     * @param password the password value to set.
     * @return the StaticSiteBasicAuthPropertiesArmResourceInner object itself.
     */
    public StaticSiteBasicAuthPropertiesArmResourceInner withPassword(String password) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StaticSiteBasicAuthPropertiesArmResourceProperties();
        }
        this.innerProperties().withPassword(password);
        return this;
    }

    /**
     * Get the secretUrl property: Url to the secret in Key Vault.
     * 
     * @return the secretUrl value.
     */
    public String secretUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().secretUrl();
    }

    /**
     * Set the secretUrl property: Url to the secret in Key Vault.
     * 
     * @param secretUrl the secretUrl value to set.
     * @return the StaticSiteBasicAuthPropertiesArmResourceInner object itself.
     */
    public StaticSiteBasicAuthPropertiesArmResourceInner withSecretUrl(String secretUrl) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StaticSiteBasicAuthPropertiesArmResourceProperties();
        }
        this.innerProperties().withSecretUrl(secretUrl);
        return this;
    }

    /**
     * Get the applicableEnvironmentsMode property: State indicating if basic auth is enabled and for what environments
     * it is active.
     * 
     * @return the applicableEnvironmentsMode value.
     */
    public String applicableEnvironmentsMode() {
        return this.innerProperties() == null ? null : this.innerProperties().applicableEnvironmentsMode();
    }

    /**
     * Set the applicableEnvironmentsMode property: State indicating if basic auth is enabled and for what environments
     * it is active.
     * 
     * @param applicableEnvironmentsMode the applicableEnvironmentsMode value to set.
     * @return the StaticSiteBasicAuthPropertiesArmResourceInner object itself.
     */
    public StaticSiteBasicAuthPropertiesArmResourceInner
        withApplicableEnvironmentsMode(String applicableEnvironmentsMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StaticSiteBasicAuthPropertiesArmResourceProperties();
        }
        this.innerProperties().withApplicableEnvironmentsMode(applicableEnvironmentsMode);
        return this;
    }

    /**
     * Get the environments property: The list of enabled environments for Basic Auth if ApplicableEnvironmentsMode is
     * set to SpecifiedEnvironments.
     * 
     * @return the environments value.
     */
    public List<String> environments() {
        return this.innerProperties() == null ? null : this.innerProperties().environments();
    }

    /**
     * Set the environments property: The list of enabled environments for Basic Auth if ApplicableEnvironmentsMode is
     * set to SpecifiedEnvironments.
     * 
     * @param environments the environments value to set.
     * @return the StaticSiteBasicAuthPropertiesArmResourceInner object itself.
     */
    public StaticSiteBasicAuthPropertiesArmResourceInner withEnvironments(List<String> environments) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StaticSiteBasicAuthPropertiesArmResourceProperties();
        }
        this.innerProperties().withEnvironments(environments);
        return this;
    }

    /**
     * Get the secretState property: State indicating if basic auth has a secret and what type it is.
     * 
     * @return the secretState value.
     */
    public String secretState() {
        return this.innerProperties() == null ? null : this.innerProperties().secretState();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", kind());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StaticSiteBasicAuthPropertiesArmResourceInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of StaticSiteBasicAuthPropertiesArmResourceInner if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the StaticSiteBasicAuthPropertiesArmResourceInner.
     */
    public static StaticSiteBasicAuthPropertiesArmResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StaticSiteBasicAuthPropertiesArmResourceInner deserializedStaticSiteBasicAuthPropertiesArmResourceInner
                = new StaticSiteBasicAuthPropertiesArmResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedStaticSiteBasicAuthPropertiesArmResourceInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedStaticSiteBasicAuthPropertiesArmResourceInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedStaticSiteBasicAuthPropertiesArmResourceInner.type = reader.getString();
                } else if ("kind".equals(fieldName)) {
                    deserializedStaticSiteBasicAuthPropertiesArmResourceInner.withKind(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedStaticSiteBasicAuthPropertiesArmResourceInner.innerProperties
                        = StaticSiteBasicAuthPropertiesArmResourceProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedStaticSiteBasicAuthPropertiesArmResourceInner;
        });
    }
}
