// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * PremierAddOnPatchResource resource specific properties.
 */
@Fluent
public final class PremierAddOnPatchResourceProperties
    implements JsonSerializable<PremierAddOnPatchResourceProperties> {
    /*
     * Premier add on SKU.
     */
    private String sku;

    /*
     * Premier add on Product.
     */
    private String product;

    /*
     * Premier add on Vendor.
     */
    private String vendor;

    /*
     * Premier add on Marketplace publisher.
     */
    private String marketplacePublisher;

    /*
     * Premier add on Marketplace offer.
     */
    private String marketplaceOffer;

    /**
     * Creates an instance of PremierAddOnPatchResourceProperties class.
     */
    public PremierAddOnPatchResourceProperties() {
    }

    /**
     * Get the sku property: Premier add on SKU.
     * 
     * @return the sku value.
     */
    public String sku() {
        return this.sku;
    }

    /**
     * Set the sku property: Premier add on SKU.
     * 
     * @param sku the sku value to set.
     * @return the PremierAddOnPatchResourceProperties object itself.
     */
    public PremierAddOnPatchResourceProperties withSku(String sku) {
        this.sku = sku;
        return this;
    }

    /**
     * Get the product property: Premier add on Product.
     * 
     * @return the product value.
     */
    public String product() {
        return this.product;
    }

    /**
     * Set the product property: Premier add on Product.
     * 
     * @param product the product value to set.
     * @return the PremierAddOnPatchResourceProperties object itself.
     */
    public PremierAddOnPatchResourceProperties withProduct(String product) {
        this.product = product;
        return this;
    }

    /**
     * Get the vendor property: Premier add on Vendor.
     * 
     * @return the vendor value.
     */
    public String vendor() {
        return this.vendor;
    }

    /**
     * Set the vendor property: Premier add on Vendor.
     * 
     * @param vendor the vendor value to set.
     * @return the PremierAddOnPatchResourceProperties object itself.
     */
    public PremierAddOnPatchResourceProperties withVendor(String vendor) {
        this.vendor = vendor;
        return this;
    }

    /**
     * Get the marketplacePublisher property: Premier add on Marketplace publisher.
     * 
     * @return the marketplacePublisher value.
     */
    public String marketplacePublisher() {
        return this.marketplacePublisher;
    }

    /**
     * Set the marketplacePublisher property: Premier add on Marketplace publisher.
     * 
     * @param marketplacePublisher the marketplacePublisher value to set.
     * @return the PremierAddOnPatchResourceProperties object itself.
     */
    public PremierAddOnPatchResourceProperties withMarketplacePublisher(String marketplacePublisher) {
        this.marketplacePublisher = marketplacePublisher;
        return this;
    }

    /**
     * Get the marketplaceOffer property: Premier add on Marketplace offer.
     * 
     * @return the marketplaceOffer value.
     */
    public String marketplaceOffer() {
        return this.marketplaceOffer;
    }

    /**
     * Set the marketplaceOffer property: Premier add on Marketplace offer.
     * 
     * @param marketplaceOffer the marketplaceOffer value to set.
     * @return the PremierAddOnPatchResourceProperties object itself.
     */
    public PremierAddOnPatchResourceProperties withMarketplaceOffer(String marketplaceOffer) {
        this.marketplaceOffer = marketplaceOffer;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sku", this.sku);
        jsonWriter.writeStringField("product", this.product);
        jsonWriter.writeStringField("vendor", this.vendor);
        jsonWriter.writeStringField("marketplacePublisher", this.marketplacePublisher);
        jsonWriter.writeStringField("marketplaceOffer", this.marketplaceOffer);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PremierAddOnPatchResourceProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PremierAddOnPatchResourceProperties if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PremierAddOnPatchResourceProperties.
     */
    public static PremierAddOnPatchResourceProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PremierAddOnPatchResourceProperties deserializedPremierAddOnPatchResourceProperties
                = new PremierAddOnPatchResourceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("sku".equals(fieldName)) {
                    deserializedPremierAddOnPatchResourceProperties.sku = reader.getString();
                } else if ("product".equals(fieldName)) {
                    deserializedPremierAddOnPatchResourceProperties.product = reader.getString();
                } else if ("vendor".equals(fieldName)) {
                    deserializedPremierAddOnPatchResourceProperties.vendor = reader.getString();
                } else if ("marketplacePublisher".equals(fieldName)) {
                    deserializedPremierAddOnPatchResourceProperties.marketplacePublisher = reader.getString();
                } else if ("marketplaceOffer".equals(fieldName)) {
                    deserializedPremierAddOnPatchResourceProperties.marketplaceOffer = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPremierAddOnPatchResourceProperties;
        });
    }
}
