// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.PerfMonSet;
import java.io.IOException;

/**
 * Performance monitor API response.
 */
@Fluent
public final class PerfMonResponseInner implements JsonSerializable<PerfMonResponseInner> {
    /*
     * The response code.
     */
    private String code;

    /*
     * The message.
     */
    private String message;

    /*
     * The performance monitor counters.
     */
    private PerfMonSet data;

    /**
     * Creates an instance of PerfMonResponseInner class.
     */
    public PerfMonResponseInner() {
    }

    /**
     * Get the code property: The response code.
     * 
     * @return the code value.
     */
    public String code() {
        return this.code;
    }

    /**
     * Set the code property: The response code.
     * 
     * @param code the code value to set.
     * @return the PerfMonResponseInner object itself.
     */
    public PerfMonResponseInner withCode(String code) {
        this.code = code;
        return this;
    }

    /**
     * Get the message property: The message.
     * 
     * @return the message value.
     */
    public String message() {
        return this.message;
    }

    /**
     * Set the message property: The message.
     * 
     * @param message the message value to set.
     * @return the PerfMonResponseInner object itself.
     */
    public PerfMonResponseInner withMessage(String message) {
        this.message = message;
        return this;
    }

    /**
     * Get the data property: The performance monitor counters.
     * 
     * @return the data value.
     */
    public PerfMonSet data() {
        return this.data;
    }

    /**
     * Set the data property: The performance monitor counters.
     * 
     * @param data the data value to set.
     * @return the PerfMonResponseInner object itself.
     */
    public PerfMonResponseInner withData(PerfMonSet data) {
        this.data = data;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (data() != null) {
            data().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("code", this.code);
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeJsonField("data", this.data);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PerfMonResponseInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PerfMonResponseInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PerfMonResponseInner.
     */
    public static PerfMonResponseInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PerfMonResponseInner deserializedPerfMonResponseInner = new PerfMonResponseInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("code".equals(fieldName)) {
                    deserializedPerfMonResponseInner.code = reader.getString();
                } else if ("message".equals(fieldName)) {
                    deserializedPerfMonResponseInner.message = reader.getString();
                } else if ("data".equals(fieldName)) {
                    deserializedPerfMonResponseInner.data = PerfMonSet.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPerfMonResponseInner;
        });
    }
}
