// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Diagnostics for an App Service Environment.
 */
@Fluent
public final class HostingEnvironmentDiagnosticsInner implements JsonSerializable<HostingEnvironmentDiagnosticsInner> {
    /*
     * Name/identifier of the diagnostics.
     */
    private String name;

    /*
     * Diagnostics output.
     */
    private String diagnosticsOutput;

    /**
     * Creates an instance of HostingEnvironmentDiagnosticsInner class.
     */
    public HostingEnvironmentDiagnosticsInner() {
    }

    /**
     * Get the name property: Name/identifier of the diagnostics.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name/identifier of the diagnostics.
     * 
     * @param name the name value to set.
     * @return the HostingEnvironmentDiagnosticsInner object itself.
     */
    public HostingEnvironmentDiagnosticsInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the diagnosticsOutput property: Diagnostics output.
     * 
     * @return the diagnosticsOutput value.
     */
    public String diagnosticsOutput() {
        return this.diagnosticsOutput;
    }

    /**
     * Set the diagnosticsOutput property: Diagnostics output.
     * 
     * @param diagnosticsOutput the diagnosticsOutput value to set.
     * @return the HostingEnvironmentDiagnosticsInner object itself.
     */
    public HostingEnvironmentDiagnosticsInner withDiagnosticsOutput(String diagnosticsOutput) {
        this.diagnosticsOutput = diagnosticsOutput;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("diagnosticsOutput", this.diagnosticsOutput);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of HostingEnvironmentDiagnosticsInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of HostingEnvironmentDiagnosticsInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the HostingEnvironmentDiagnosticsInner.
     */
    public static HostingEnvironmentDiagnosticsInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            HostingEnvironmentDiagnosticsInner deserializedHostingEnvironmentDiagnosticsInner
                = new HostingEnvironmentDiagnosticsInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedHostingEnvironmentDiagnosticsInner.name = reader.getString();
                } else if ("diagnosticsOutput".equals(fieldName)) {
                    deserializedHostingEnvironmentDiagnosticsInner.diagnosticsOutput = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedHostingEnvironmentDiagnosticsInner;
        });
    }
}
