// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * DiagnosticCategory resource specific properties.
 */
@Immutable
public final class DiagnosticCategoryProperties implements JsonSerializable<DiagnosticCategoryProperties> {
    /*
     * Description of the diagnostic category
     */
    private String description;

    /**
     * Creates an instance of DiagnosticCategoryProperties class.
     */
    public DiagnosticCategoryProperties() {
    }

    /**
     * Get the description property: Description of the diagnostic category.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DiagnosticCategoryProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DiagnosticCategoryProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DiagnosticCategoryProperties.
     */
    public static DiagnosticCategoryProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DiagnosticCategoryProperties deserializedDiagnosticCategoryProperties = new DiagnosticCategoryProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("description".equals(fieldName)) {
                    deserializedDiagnosticCategoryProperties.description = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDiagnosticCategoryProperties;
        });
    }
}
