// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Class representing detector definition.
 */
@Immutable
public final class DetectorDefinition implements JsonSerializable<DetectorDefinition> {
    /*
     * Display name of the detector
     */
    private String displayName;

    /*
     * Description of the detector
     */
    private String description;

    /*
     * Detector Rank
     */
    private Double rank;

    /*
     * Flag representing whether detector is enabled or not.
     */
    private Boolean isEnabled;

    /**
     * Creates an instance of DetectorDefinition class.
     */
    public DetectorDefinition() {
    }

    /**
     * Get the displayName property: Display name of the detector.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Get the description property: Description of the detector.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Get the rank property: Detector Rank.
     * 
     * @return the rank value.
     */
    public Double rank() {
        return this.rank;
    }

    /**
     * Get the isEnabled property: Flag representing whether detector is enabled or not.
     * 
     * @return the isEnabled value.
     */
    public Boolean isEnabled() {
        return this.isEnabled;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DetectorDefinition from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DetectorDefinition if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the DetectorDefinition.
     */
    public static DetectorDefinition fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DetectorDefinition deserializedDetectorDefinition = new DetectorDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("displayName".equals(fieldName)) {
                    deserializedDetectorDefinition.displayName = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedDetectorDefinition.description = reader.getString();
                } else if ("rank".equals(fieldName)) {
                    deserializedDetectorDefinition.rank = reader.getNullable(JsonReader::getDouble);
                } else if ("isEnabled".equals(fieldName)) {
                    deserializedDetectorDefinition.isEnabled = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDetectorDefinition;
        });
    }
}
