// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * CustomHostnameSites resource specific properties.
 */
@Fluent
public final class CustomHostnameSitesProperties implements JsonSerializable<CustomHostnameSitesProperties> {
    /*
     * The customHostname property.
     */
    private String customHostname;

    /*
     * The region property.
     */
    private String region;

    /*
     * The siteResourceIds property.
     */
    private List<IdentifierInner> siteResourceIds;

    /**
     * Creates an instance of CustomHostnameSitesProperties class.
     */
    public CustomHostnameSitesProperties() {
    }

    /**
     * Get the customHostname property: The customHostname property.
     * 
     * @return the customHostname value.
     */
    public String customHostname() {
        return this.customHostname;
    }

    /**
     * Set the customHostname property: The customHostname property.
     * 
     * @param customHostname the customHostname value to set.
     * @return the CustomHostnameSitesProperties object itself.
     */
    public CustomHostnameSitesProperties withCustomHostname(String customHostname) {
        this.customHostname = customHostname;
        return this;
    }

    /**
     * Get the region property: The region property.
     * 
     * @return the region value.
     */
    public String region() {
        return this.region;
    }

    /**
     * Set the region property: The region property.
     * 
     * @param region the region value to set.
     * @return the CustomHostnameSitesProperties object itself.
     */
    public CustomHostnameSitesProperties withRegion(String region) {
        this.region = region;
        return this;
    }

    /**
     * Get the siteResourceIds property: The siteResourceIds property.
     * 
     * @return the siteResourceIds value.
     */
    public List<IdentifierInner> siteResourceIds() {
        return this.siteResourceIds;
    }

    /**
     * Set the siteResourceIds property: The siteResourceIds property.
     * 
     * @param siteResourceIds the siteResourceIds value to set.
     * @return the CustomHostnameSitesProperties object itself.
     */
    public CustomHostnameSitesProperties withSiteResourceIds(List<IdentifierInner> siteResourceIds) {
        this.siteResourceIds = siteResourceIds;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (siteResourceIds() != null) {
            siteResourceIds().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("customHostname", this.customHostname);
        jsonWriter.writeStringField("region", this.region);
        jsonWriter.writeArrayField("siteResourceIds", this.siteResourceIds,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CustomHostnameSitesProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CustomHostnameSitesProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CustomHostnameSitesProperties.
     */
    public static CustomHostnameSitesProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CustomHostnameSitesProperties deserializedCustomHostnameSitesProperties
                = new CustomHostnameSitesProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("customHostname".equals(fieldName)) {
                    deserializedCustomHostnameSitesProperties.customHostname = reader.getString();
                } else if ("region".equals(fieldName)) {
                    deserializedCustomHostnameSitesProperties.region = reader.getString();
                } else if ("siteResourceIds".equals(fieldName)) {
                    List<IdentifierInner> siteResourceIds
                        = reader.readArray(reader1 -> IdentifierInner.fromJson(reader1));
                    deserializedCustomHostnameSitesProperties.siteResourceIds = siteResourceIds;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCustomHostnameSitesProperties;
        });
    }
}
