// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.Configuration;
import com.azure.resourcemanager.appservice.models.ContainerAppProvisioningState;
import com.azure.resourcemanager.appservice.models.Template;
import java.io.IOException;

/**
 * ContainerApp resource specific properties.
 */
@Fluent
public final class ContainerAppProperties implements JsonSerializable<ContainerAppProperties> {
    /*
     * Provisioning state of the Container App.
     */
    private ContainerAppProvisioningState provisioningState;

    /*
     * Resource ID of the Container App's KubeEnvironment.
     */
    private String kubeEnvironmentId;

    /*
     * Name of the latest revision of the Container App.
     */
    private String latestRevisionName;

    /*
     * Fully Qualified Domain Name of the latest revision of the Container App.
     */
    private String latestRevisionFqdn;

    /*
     * Non versioned Container App configuration properties.
     */
    private Configuration configuration;

    /*
     * Container App versioned application definition.
     */
    private Template template;

    /**
     * Creates an instance of ContainerAppProperties class.
     */
    public ContainerAppProperties() {
    }

    /**
     * Get the provisioningState property: Provisioning state of the Container App.
     * 
     * @return the provisioningState value.
     */
    public ContainerAppProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the kubeEnvironmentId property: Resource ID of the Container App's KubeEnvironment.
     * 
     * @return the kubeEnvironmentId value.
     */
    public String kubeEnvironmentId() {
        return this.kubeEnvironmentId;
    }

    /**
     * Set the kubeEnvironmentId property: Resource ID of the Container App's KubeEnvironment.
     * 
     * @param kubeEnvironmentId the kubeEnvironmentId value to set.
     * @return the ContainerAppProperties object itself.
     */
    public ContainerAppProperties withKubeEnvironmentId(String kubeEnvironmentId) {
        this.kubeEnvironmentId = kubeEnvironmentId;
        return this;
    }

    /**
     * Get the latestRevisionName property: Name of the latest revision of the Container App.
     * 
     * @return the latestRevisionName value.
     */
    public String latestRevisionName() {
        return this.latestRevisionName;
    }

    /**
     * Get the latestRevisionFqdn property: Fully Qualified Domain Name of the latest revision of the Container App.
     * 
     * @return the latestRevisionFqdn value.
     */
    public String latestRevisionFqdn() {
        return this.latestRevisionFqdn;
    }

    /**
     * Get the configuration property: Non versioned Container App configuration properties.
     * 
     * @return the configuration value.
     */
    public Configuration configuration() {
        return this.configuration;
    }

    /**
     * Set the configuration property: Non versioned Container App configuration properties.
     * 
     * @param configuration the configuration value to set.
     * @return the ContainerAppProperties object itself.
     */
    public ContainerAppProperties withConfiguration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    /**
     * Get the template property: Container App versioned application definition.
     * 
     * @return the template value.
     */
    public Template template() {
        return this.template;
    }

    /**
     * Set the template property: Container App versioned application definition.
     * 
     * @param template the template value to set.
     * @return the ContainerAppProperties object itself.
     */
    public ContainerAppProperties withTemplate(Template template) {
        this.template = template;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (configuration() != null) {
            configuration().validate();
        }
        if (template() != null) {
            template().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kubeEnvironmentId", this.kubeEnvironmentId);
        jsonWriter.writeJsonField("configuration", this.configuration);
        jsonWriter.writeJsonField("template", this.template);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ContainerAppProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ContainerAppProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ContainerAppProperties.
     */
    public static ContainerAppProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ContainerAppProperties deserializedContainerAppProperties = new ContainerAppProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("provisioningState".equals(fieldName)) {
                    deserializedContainerAppProperties.provisioningState
                        = ContainerAppProvisioningState.fromString(reader.getString());
                } else if ("kubeEnvironmentId".equals(fieldName)) {
                    deserializedContainerAppProperties.kubeEnvironmentId = reader.getString();
                } else if ("latestRevisionName".equals(fieldName)) {
                    deserializedContainerAppProperties.latestRevisionName = reader.getString();
                } else if ("latestRevisionFqdn".equals(fieldName)) {
                    deserializedContainerAppProperties.latestRevisionFqdn = reader.getString();
                } else if ("configuration".equals(fieldName)) {
                    deserializedContainerAppProperties.configuration = Configuration.fromJson(reader);
                } else if ("template".equals(fieldName)) {
                    deserializedContainerAppProperties.template = Template.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedContainerAppProperties;
        });
    }
}
