/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.StaticSiteArmResourceInner;
import java.io.IOException;
import java.util.List;

public final class StaticSiteCollection
implements JsonSerializable<StaticSiteCollection> {
    private List<StaticSiteArmResourceInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(StaticSiteCollection.class);

    public List<StaticSiteArmResourceInner> value() {
        return this.value;
    }

    public StaticSiteCollection withValue(List<StaticSiteArmResourceInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model StaticSiteCollection"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static StaticSiteCollection fromJson(JsonReader jsonReader) throws IOException {
        return (StaticSiteCollection)jsonReader.readObject(reader -> {
            StaticSiteCollection deserializedStaticSiteCollection = new StaticSiteCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedStaticSiteCollection.value = value = reader.readArray(reader1 -> StaticSiteArmResourceInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedStaticSiteCollection.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStaticSiteCollection;
        });
    }
}

