// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.WorkflowRunActionInner;
import java.io.IOException;
import java.util.List;

/**
 * The list of workflow run actions.
 */
@Fluent
public final class WorkflowRunActionListResult implements JsonSerializable<WorkflowRunActionListResult> {
    /*
     * A list of workflow run actions.
     */
    private List<WorkflowRunActionInner> value;

    /*
     * The URL to get the next set of results.
     */
    private String nextLink;

    /**
     * Creates an instance of WorkflowRunActionListResult class.
     */
    public WorkflowRunActionListResult() {
    }

    /**
     * Get the value property: A list of workflow run actions.
     * 
     * @return the value value.
     */
    public List<WorkflowRunActionInner> value() {
        return this.value;
    }

    /**
     * Set the value property: A list of workflow run actions.
     * 
     * @param value the value value to set.
     * @return the WorkflowRunActionListResult object itself.
     */
    public WorkflowRunActionListResult withValue(List<WorkflowRunActionInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to get the next set of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URL to get the next set of results.
     * 
     * @param nextLink the nextLink value to set.
     * @return the WorkflowRunActionListResult object itself.
     */
    public WorkflowRunActionListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WorkflowRunActionListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WorkflowRunActionListResult if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the WorkflowRunActionListResult.
     */
    public static WorkflowRunActionListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WorkflowRunActionListResult deserializedWorkflowRunActionListResult = new WorkflowRunActionListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<WorkflowRunActionInner> value
                        = reader.readArray(reader1 -> WorkflowRunActionInner.fromJson(reader1));
                    deserializedWorkflowRunActionListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedWorkflowRunActionListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedWorkflowRunActionListResult;
        });
    }
}
