// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The SiteDnsConfig model.
 */
@Fluent
public final class SiteDnsConfig implements JsonSerializable<SiteDnsConfig> {
    /*
     * List of custom DNS servers to be used by an app for lookups. Maximum 5 dns servers can be set.
     */
    private List<String> dnsServers;

    /*
     * Alternate DNS server to be used by apps. This property replicates the WEBSITE_DNS_ALT_SERVER app setting.
     */
    private String dnsAltServer;

    /*
     * Timeout for a single dns lookup in seconds. Allowed range: 1-30. Default is 3.
     */
    private Integer dnsRetryAttemptTimeout;

    /*
     * Total number of retries for dns lookup. Allowed range: 1-5. Default is 3.
     */
    private Integer dnsRetryAttemptCount;

    /*
     * Custom time for DNS to be cached in seconds. Allowed range: 0-60. Default is 30 seconds. 0 means caching
     * disabled.
     */
    private Integer dnsMaxCacheTimeout;

    /*
     * Indicates that sites using Virtual network custom DNS servers are still sorting the list of DNS servers.
     * Read-Only.
     */
    private Boolean dnsLegacySortOrder;

    /**
     * Creates an instance of SiteDnsConfig class.
     */
    public SiteDnsConfig() {
    }

    /**
     * Get the dnsServers property: List of custom DNS servers to be used by an app for lookups. Maximum 5 dns servers
     * can be set.
     * 
     * @return the dnsServers value.
     */
    public List<String> dnsServers() {
        return this.dnsServers;
    }

    /**
     * Set the dnsServers property: List of custom DNS servers to be used by an app for lookups. Maximum 5 dns servers
     * can be set.
     * 
     * @param dnsServers the dnsServers value to set.
     * @return the SiteDnsConfig object itself.
     */
    public SiteDnsConfig withDnsServers(List<String> dnsServers) {
        this.dnsServers = dnsServers;
        return this;
    }

    /**
     * Get the dnsAltServer property: Alternate DNS server to be used by apps. This property replicates the
     * WEBSITE_DNS_ALT_SERVER app setting.
     * 
     * @return the dnsAltServer value.
     */
    public String dnsAltServer() {
        return this.dnsAltServer;
    }

    /**
     * Set the dnsAltServer property: Alternate DNS server to be used by apps. This property replicates the
     * WEBSITE_DNS_ALT_SERVER app setting.
     * 
     * @param dnsAltServer the dnsAltServer value to set.
     * @return the SiteDnsConfig object itself.
     */
    public SiteDnsConfig withDnsAltServer(String dnsAltServer) {
        this.dnsAltServer = dnsAltServer;
        return this;
    }

    /**
     * Get the dnsRetryAttemptTimeout property: Timeout for a single dns lookup in seconds. Allowed range: 1-30. Default
     * is 3.
     * 
     * @return the dnsRetryAttemptTimeout value.
     */
    public Integer dnsRetryAttemptTimeout() {
        return this.dnsRetryAttemptTimeout;
    }

    /**
     * Set the dnsRetryAttemptTimeout property: Timeout for a single dns lookup in seconds. Allowed range: 1-30. Default
     * is 3.
     * 
     * @param dnsRetryAttemptTimeout the dnsRetryAttemptTimeout value to set.
     * @return the SiteDnsConfig object itself.
     */
    public SiteDnsConfig withDnsRetryAttemptTimeout(Integer dnsRetryAttemptTimeout) {
        this.dnsRetryAttemptTimeout = dnsRetryAttemptTimeout;
        return this;
    }

    /**
     * Get the dnsRetryAttemptCount property: Total number of retries for dns lookup. Allowed range: 1-5. Default is 3.
     * 
     * @return the dnsRetryAttemptCount value.
     */
    public Integer dnsRetryAttemptCount() {
        return this.dnsRetryAttemptCount;
    }

    /**
     * Set the dnsRetryAttemptCount property: Total number of retries for dns lookup. Allowed range: 1-5. Default is 3.
     * 
     * @param dnsRetryAttemptCount the dnsRetryAttemptCount value to set.
     * @return the SiteDnsConfig object itself.
     */
    public SiteDnsConfig withDnsRetryAttemptCount(Integer dnsRetryAttemptCount) {
        this.dnsRetryAttemptCount = dnsRetryAttemptCount;
        return this;
    }

    /**
     * Get the dnsMaxCacheTimeout property: Custom time for DNS to be cached in seconds. Allowed range: 0-60. Default is
     * 30 seconds. 0 means caching disabled.
     * 
     * @return the dnsMaxCacheTimeout value.
     */
    public Integer dnsMaxCacheTimeout() {
        return this.dnsMaxCacheTimeout;
    }

    /**
     * Set the dnsMaxCacheTimeout property: Custom time for DNS to be cached in seconds. Allowed range: 0-60. Default is
     * 30 seconds. 0 means caching disabled.
     * 
     * @param dnsMaxCacheTimeout the dnsMaxCacheTimeout value to set.
     * @return the SiteDnsConfig object itself.
     */
    public SiteDnsConfig withDnsMaxCacheTimeout(Integer dnsMaxCacheTimeout) {
        this.dnsMaxCacheTimeout = dnsMaxCacheTimeout;
        return this;
    }

    /**
     * Get the dnsLegacySortOrder property: Indicates that sites using Virtual network custom DNS servers are still
     * sorting the list of DNS servers. Read-Only.
     * 
     * @return the dnsLegacySortOrder value.
     */
    public Boolean dnsLegacySortOrder() {
        return this.dnsLegacySortOrder;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("dnsServers", this.dnsServers, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("dnsAltServer", this.dnsAltServer);
        jsonWriter.writeNumberField("dnsRetryAttemptTimeout", this.dnsRetryAttemptTimeout);
        jsonWriter.writeNumberField("dnsRetryAttemptCount", this.dnsRetryAttemptCount);
        jsonWriter.writeNumberField("dnsMaxCacheTimeout", this.dnsMaxCacheTimeout);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SiteDnsConfig from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SiteDnsConfig if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the SiteDnsConfig.
     */
    public static SiteDnsConfig fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SiteDnsConfig deserializedSiteDnsConfig = new SiteDnsConfig();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("dnsServers".equals(fieldName)) {
                    List<String> dnsServers = reader.readArray(reader1 -> reader1.getString());
                    deserializedSiteDnsConfig.dnsServers = dnsServers;
                } else if ("dnsAltServer".equals(fieldName)) {
                    deserializedSiteDnsConfig.dnsAltServer = reader.getString();
                } else if ("dnsRetryAttemptTimeout".equals(fieldName)) {
                    deserializedSiteDnsConfig.dnsRetryAttemptTimeout = reader.getNullable(JsonReader::getInt);
                } else if ("dnsRetryAttemptCount".equals(fieldName)) {
                    deserializedSiteDnsConfig.dnsRetryAttemptCount = reader.getNullable(JsonReader::getInt);
                } else if ("dnsMaxCacheTimeout".equals(fieldName)) {
                    deserializedSiteDnsConfig.dnsMaxCacheTimeout = reader.getNullable(JsonReader::getInt);
                } else if ("dnsLegacySortOrder".equals(fieldName)) {
                    deserializedSiteDnsConfig.dnsLegacySortOrder = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSiteDnsConfig;
        });
    }
}
