// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Open authentication policy claim.
 */
@Fluent
public final class OpenAuthenticationPolicyClaim implements JsonSerializable<OpenAuthenticationPolicyClaim> {
    /*
     * The name of the claim.
     */
    private String name;

    /*
     * The value of the claim.
     */
    private String value;

    /**
     * Creates an instance of OpenAuthenticationPolicyClaim class.
     */
    public OpenAuthenticationPolicyClaim() {
    }

    /**
     * Get the name property: The name of the claim.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the claim.
     * 
     * @param name the name value to set.
     * @return the OpenAuthenticationPolicyClaim object itself.
     */
    public OpenAuthenticationPolicyClaim withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the value property: The value of the claim.
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: The value of the claim.
     * 
     * @param value the value value to set.
     * @return the OpenAuthenticationPolicyClaim object itself.
     */
    public OpenAuthenticationPolicyClaim withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("value", this.value);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OpenAuthenticationPolicyClaim from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of OpenAuthenticationPolicyClaim if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the OpenAuthenticationPolicyClaim.
     */
    public static OpenAuthenticationPolicyClaim fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OpenAuthenticationPolicyClaim deserializedOpenAuthenticationPolicyClaim
                = new OpenAuthenticationPolicyClaim();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedOpenAuthenticationPolicyClaim.name = reader.getString();
                } else if ("value".equals(fieldName)) {
                    deserializedOpenAuthenticationPolicyClaim.value = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedOpenAuthenticationPolicyClaim;
        });
    }
}
