// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The content hash.
 */
@Fluent
public final class ContentHash implements JsonSerializable<ContentHash> {
    /*
     * The algorithm of the content hash.
     */
    private String algorithm;

    /*
     * The value of the content hash.
     */
    private String value;

    /**
     * Creates an instance of ContentHash class.
     */
    public ContentHash() {
    }

    /**
     * Get the algorithm property: The algorithm of the content hash.
     * 
     * @return the algorithm value.
     */
    public String algorithm() {
        return this.algorithm;
    }

    /**
     * Set the algorithm property: The algorithm of the content hash.
     * 
     * @param algorithm the algorithm value to set.
     * @return the ContentHash object itself.
     */
    public ContentHash withAlgorithm(String algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    /**
     * Get the value property: The value of the content hash.
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: The value of the content hash.
     * 
     * @param value the value value to set.
     * @return the ContentHash object itself.
     */
    public ContentHash withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("algorithm", this.algorithm);
        jsonWriter.writeStringField("value", this.value);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ContentHash from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ContentHash if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ContentHash.
     */
    public static ContentHash fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ContentHash deserializedContentHash = new ContentHash();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("algorithm".equals(fieldName)) {
                    deserializedContentHash.algorithm = reader.getString();
                } else if ("value".equals(fieldName)) {
                    deserializedContentHash.value = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedContentHash;
        });
    }
}
