// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The configuration settings of the Apple provider.
 */
@Fluent
public final class Apple implements JsonSerializable<Apple> {
    /*
     * <code>false</code> if the Apple provider should not be enabled despite the set registration; otherwise,
     * <code>true</code>.
     */
    private Boolean enabled;

    /*
     * The configuration settings of the Apple registration.
     */
    private AppleRegistration registration;

    /*
     * The configuration settings of the login flow.
     */
    private LoginScopes login;

    /**
     * Creates an instance of Apple class.
     */
    public Apple() {
    }

    /**
     * Get the enabled property: &lt;code&gt;false&lt;/code&gt; if the Apple provider should not be enabled despite the
     * set registration; otherwise, &lt;code&gt;true&lt;/code&gt;.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: &lt;code&gt;false&lt;/code&gt; if the Apple provider should not be enabled despite the
     * set registration; otherwise, &lt;code&gt;true&lt;/code&gt;.
     * 
     * @param enabled the enabled value to set.
     * @return the Apple object itself.
     */
    public Apple withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Get the registration property: The configuration settings of the Apple registration.
     * 
     * @return the registration value.
     */
    public AppleRegistration registration() {
        return this.registration;
    }

    /**
     * Set the registration property: The configuration settings of the Apple registration.
     * 
     * @param registration the registration value to set.
     * @return the Apple object itself.
     */
    public Apple withRegistration(AppleRegistration registration) {
        this.registration = registration;
        return this;
    }

    /**
     * Get the login property: The configuration settings of the login flow.
     * 
     * @return the login value.
     */
    public LoginScopes login() {
        return this.login;
    }

    /**
     * Set the login property: The configuration settings of the login flow.
     * 
     * @param login the login value to set.
     * @return the Apple object itself.
     */
    public Apple withLogin(LoginScopes login) {
        this.login = login;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (registration() != null) {
            registration().validate();
        }
        if (login() != null) {
            login().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeJsonField("registration", this.registration);
        jsonWriter.writeJsonField("login", this.login);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Apple from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Apple if the JsonReader was pointing to an instance of it, or null if it was pointing to
     * JSON null.
     * @throws IOException If an error occurs while reading the Apple.
     */
    public static Apple fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Apple deserializedApple = new Apple();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("enabled".equals(fieldName)) {
                    deserializedApple.enabled = reader.getNullable(JsonReader::getBoolean);
                } else if ("registration".equals(fieldName)) {
                    deserializedApple.registration = AppleRegistration.fromJson(reader);
                } else if ("login".equals(fieldName)) {
                    deserializedApple.login = LoginScopes.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApple;
        });
    }
}
