// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.ResourceMetricAvailability;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * ResourceMetricDefinition resource specific properties.
 */
@Immutable
public final class ResourceMetricDefinitionProperties implements JsonSerializable<ResourceMetricDefinitionProperties> {
    /*
     * Unit of the metric.
     */
    private String unit;

    /*
     * Primary aggregation type.
     */
    private String primaryAggregationType;

    /*
     * List of time grains supported for the metric together with retention period.
     */
    private List<ResourceMetricAvailability> metricAvailabilities;

    /*
     * Resource URI.
     */
    private String resourceUri;

    /*
     * Resource metric definition properties.
     */
    private Map<String, String> properties;

    /**
     * Creates an instance of ResourceMetricDefinitionProperties class.
     */
    public ResourceMetricDefinitionProperties() {
    }

    /**
     * Get the unit property: Unit of the metric.
     * 
     * @return the unit value.
     */
    public String unit() {
        return this.unit;
    }

    /**
     * Get the primaryAggregationType property: Primary aggregation type.
     * 
     * @return the primaryAggregationType value.
     */
    public String primaryAggregationType() {
        return this.primaryAggregationType;
    }

    /**
     * Get the metricAvailabilities property: List of time grains supported for the metric together with retention
     * period.
     * 
     * @return the metricAvailabilities value.
     */
    public List<ResourceMetricAvailability> metricAvailabilities() {
        return this.metricAvailabilities;
    }

    /**
     * Get the resourceUri property: Resource URI.
     * 
     * @return the resourceUri value.
     */
    public String resourceUri() {
        return this.resourceUri;
    }

    /**
     * Get the properties property: Resource metric definition properties.
     * 
     * @return the properties value.
     */
    public Map<String, String> properties() {
        return this.properties;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (metricAvailabilities() != null) {
            metricAvailabilities().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResourceMetricDefinitionProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResourceMetricDefinitionProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ResourceMetricDefinitionProperties.
     */
    public static ResourceMetricDefinitionProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResourceMetricDefinitionProperties deserializedResourceMetricDefinitionProperties
                = new ResourceMetricDefinitionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("unit".equals(fieldName)) {
                    deserializedResourceMetricDefinitionProperties.unit = reader.getString();
                } else if ("primaryAggregationType".equals(fieldName)) {
                    deserializedResourceMetricDefinitionProperties.primaryAggregationType = reader.getString();
                } else if ("metricAvailabilities".equals(fieldName)) {
                    List<ResourceMetricAvailability> metricAvailabilities
                        = reader.readArray(reader1 -> ResourceMetricAvailability.fromJson(reader1));
                    deserializedResourceMetricDefinitionProperties.metricAvailabilities = metricAvailabilities;
                } else if ("resourceUri".equals(fieldName)) {
                    deserializedResourceMetricDefinitionProperties.resourceUri = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    Map<String, String> properties = reader.readMap(reader1 -> reader1.getString());
                    deserializedResourceMetricDefinitionProperties.properties = properties;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedResourceMetricDefinitionProperties;
        });
    }
}
