// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.MSDeployProvisioningState;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * MSDeploy ARM response.
 */
@Fluent
public final class MSDeployStatusInner extends ProxyOnlyResource {
    /*
     * MSDeployStatus resource specific properties
     */
    private MSDeployStatusProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of MSDeployStatusInner class.
     */
    public MSDeployStatusInner() {
    }

    /**
     * Get the innerProperties property: MSDeployStatus resource specific properties.
     * 
     * @return the innerProperties value.
     */
    private MSDeployStatusProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MSDeployStatusInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the deployer property: Username of deployer.
     * 
     * @return the deployer value.
     */
    public String deployer() {
        return this.innerProperties() == null ? null : this.innerProperties().deployer();
    }

    /**
     * Get the provisioningState property: Provisioning state.
     * 
     * @return the provisioningState value.
     */
    public MSDeployProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the startTime property: Start time of deploy operation.
     * 
     * @return the startTime value.
     */
    public OffsetDateTime startTime() {
        return this.innerProperties() == null ? null : this.innerProperties().startTime();
    }

    /**
     * Get the endTime property: End time of deploy operation.
     * 
     * @return the endTime value.
     */
    public OffsetDateTime endTime() {
        return this.innerProperties() == null ? null : this.innerProperties().endTime();
    }

    /**
     * Get the complete property: Whether the deployment operation has completed.
     * 
     * @return the complete value.
     */
    public Boolean complete() {
        return this.innerProperties() == null ? null : this.innerProperties().complete();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", kind());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MSDeployStatusInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MSDeployStatusInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the MSDeployStatusInner.
     */
    public static MSDeployStatusInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MSDeployStatusInner deserializedMSDeployStatusInner = new MSDeployStatusInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMSDeployStatusInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedMSDeployStatusInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedMSDeployStatusInner.type = reader.getString();
                } else if ("kind".equals(fieldName)) {
                    deserializedMSDeployStatusInner.withKind(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedMSDeployStatusInner.innerProperties = MSDeployStatusProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMSDeployStatusInner;
        });
    }
}
