/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.SnapshotRestoreRequestProperties;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.azure.resourcemanager.appservice.models.SnapshotRecoverySource;
import java.io.IOException;

public final class SnapshotRestoreRequest
extends ProxyOnlyResource {
    private SnapshotRestoreRequestProperties innerProperties;
    private String id;
    private String name;
    private String type;

    private SnapshotRestoreRequestProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public SnapshotRestoreRequest withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    public String snapshotTime() {
        return this.innerProperties() == null ? null : this.innerProperties().snapshotTime();
    }

    public SnapshotRestoreRequest withSnapshotTime(String snapshotTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SnapshotRestoreRequestProperties();
        }
        this.innerProperties().withSnapshotTime(snapshotTime);
        return this;
    }

    public SnapshotRecoverySource recoverySource() {
        return this.innerProperties() == null ? null : this.innerProperties().recoverySource();
    }

    public SnapshotRestoreRequest withRecoverySource(SnapshotRecoverySource recoverySource) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SnapshotRestoreRequestProperties();
        }
        this.innerProperties().withRecoverySource(recoverySource);
        return this;
    }

    public Boolean overwrite() {
        return this.innerProperties() == null ? null : Boolean.valueOf(this.innerProperties().overwrite());
    }

    public SnapshotRestoreRequest withOverwrite(Boolean overwrite) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SnapshotRestoreRequestProperties();
        }
        this.innerProperties().withOverwrite(overwrite);
        return this;
    }

    public Boolean recoverConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().recoverConfiguration();
    }

    public SnapshotRestoreRequest withRecoverConfiguration(Boolean recoverConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SnapshotRestoreRequestProperties();
        }
        this.innerProperties().withRecoverConfiguration(recoverConfiguration);
        return this;
    }

    public Boolean ignoreConflictingHostNames() {
        return this.innerProperties() == null ? null : this.innerProperties().ignoreConflictingHostNames();
    }

    public SnapshotRestoreRequest withIgnoreConflictingHostNames(Boolean ignoreConflictingHostNames) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SnapshotRestoreRequestProperties();
        }
        this.innerProperties().withIgnoreConflictingHostNames(ignoreConflictingHostNames);
        return this;
    }

    public Boolean useDRSecondary() {
        return this.innerProperties() == null ? null : this.innerProperties().useDRSecondary();
    }

    public SnapshotRestoreRequest withUseDRSecondary(Boolean useDRSecondary) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SnapshotRestoreRequestProperties();
        }
        this.innerProperties().withUseDRSecondary(useDRSecondary);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static SnapshotRestoreRequest fromJson(JsonReader jsonReader) throws IOException {
        return (SnapshotRestoreRequest)((Object)jsonReader.readObject(reader -> {
            SnapshotRestoreRequest deserializedSnapshotRestoreRequest = new SnapshotRestoreRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSnapshotRestoreRequest.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSnapshotRestoreRequest.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSnapshotRestoreRequest.type = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedSnapshotRestoreRequest.withKind(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedSnapshotRestoreRequest.innerProperties = SnapshotRestoreRequestProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSnapshotRestoreRequest;
        }));
    }
}

